% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transportation.R
\name{primary_secondary_roads}
\alias{primary_secondary_roads}
\title{Download a primary & secondary roads shapefile into R}
\usage{
primary_secondary_roads(state, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like
to download the roads for. Can also be state name or abbreviation
(case-insensitive).}

\item{year}{the data year; defaults to 2021}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\value{
an sf object with columns
\itemize{
\item \code{LINEARID}: a unique line feature identifier \href{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2019/TGRSHP2019_TechDoc.pdf}{(source)}
\item \code{FULLNAME}: display name \href{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2019/TGRSHP2019_TechDoc.pdf}{(source)}
\item \code{RTTYP}: describes the types of roads used \href{https://www.census.gov/library/reference/code-lists/route-type-codes.html}{(source)}. Possible values are:
\itemize{
\item "C": county
\item "I": interstate
\item "M": common name
\item "O": other
\item "S": state regonized
\item "U": U.S.
}
\item \code{MTFCC}: 5-digit geographic code assignment \href{https://www.census.gov/library/reference/code-lists/mt-feature-class-codes.html}{(see annual assignments)}
}
}
\description{
From the Census Bureau: "Primary roads are generally divided,
limited-access highways within the Federal interstate highway
system or under state management. These highways are distinguished by the presence of interchanges
and are accessible by ramps and may include some toll highways. Secondary roads are main arteries,
usually in the U.S. highway, state
highway, or county highway system. These roads have one or more lanes of
traffic in each direction, may
or may not be divided, and usually have at-grade intersections with many other roads and driveways.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\examples{
\dontrun{
library(tigris)

rds <- primary_secondary_roads()

plot(rds$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc.pdf}

Other transportation functions: 
\code{\link{address_ranges}()},
\code{\link{primary_roads}()},
\code{\link{rails}()},
\code{\link{roads}()}
}
\concept{transportation functions}
