% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iqa.R, R/iqa_equations.R
\name{iqa}
\alias{iqa}
\title{Water Quality Index (WQI / IQA)}
\usage{
iqa(
  df,
  pesos = c(od = 0.17, coliformes = 0.15, pH = 0.12, dbo = 0.1, nt_total = 0.1, p_total =
    0.1, turbidez = 0.08, tds = 0.08, temperatura = 0.1),
  altitude_m = 0,
  na_rm = FALSE
)

iqa(
  df,
  pesos = c(od = 0.17, coliformes = 0.15, pH = 0.12, dbo = 0.1, nt_total = 0.1, p_total =
    0.1, turbidez = 0.08, tds = 0.08, temperatura = 0.1),
  altitude_m = 0,
  na_rm = FALSE
)
}
\arguments{
\item{df}{cols: pH, turbidez, od, dbo, nt_total, p_total, tds, temperatura, coliformes}

\item{pesos}{pesos oficiais (ANA/CETESB)}

\item{altitude_m}{altitude (m) p/ \%sat de OD}

\item{na_rm}{reescala pesos nos parâmetros presentes}
}
\value{
A tibble/data frame with columns such as \code{site}, \code{date},
\code{iqa} (numeric score), and \code{class} (qualitative label).
}
\description{
Computes IQA/WQI for each site/date (or grouping).
}
