% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk_zooreg.R
\name{tk_zooreg}
\alias{tk_zooreg}
\alias{tk_zooreg_}
\title{Coerce time series objects and tibbles with date/date-time columns to ts.}
\usage{
tk_zooreg(data, select = NULL, date_var = NULL, start = 1,
  end = numeric(), frequency = 1, deltat = 1,
  ts.eps = getOption("ts.eps"), order.by = NULL, silent = FALSE)

tk_zooreg_(data, select = NULL, date_var = NULL, start = 1,
  end = numeric(), frequency = 1, deltat = 1,
  ts.eps = getOption("ts.eps"), order.by = NULL, silent = FALSE)
}
\arguments{
\item{data}{A time-based tibble or time-series object.}

\item{select}{\strong{Applicable to tibbles and data frames only}.
The column or set of columns to be coerced to \code{zooreg} class.}

\item{date_var}{\strong{Applicable to tibbles and data frames only}.
Column name to be used to \code{order.by}.
\code{NULL} by default. If \code{NULL}, function will find the date or date-time column.}

\item{start}{the time of the first observation.  Either a single number or
    a vector of two integers, which specify a natural time unit
    and a (1-based) number of samples into the time unit.}

\item{end}{the time of the last observation, specified in the same way
    as \code{start}.}

\item{frequency}{the number of observations per unit of time.}

\item{deltat}{the fraction of the sampling period between successive
    observations; e.g., 1/12 for monthly data.  Only one of
    \code{frequency} or \code{deltat} should be provided.}

\item{ts.eps}{time series comparison tolerance.  Frequencies are considered
    equal if their absolute difference is less than \code{ts.eps}.}

\item{order.by}{a vector by which the observations in \code{x}
    are ordered. If this is specified the arguments \code{start} and
    \code{end} are ignored and \code{zoo(data, order.by, frequency)} is
    called. See \code{\link{zoo}} for more information.}

\item{silent}{Used to toggle printing of messages and warnings.}
}
\value{
Returns a \code{zooreg} object.
}
\description{
Coerce time series objects and tibbles with date/date-time columns to ts.
}
\details{
\code{tk_zooreg()} is a wrapper for \code{zoo::zooreg()} that is designed
to coerce \code{tibble} objects that have a "time-base" (meaning the values vary with time)
to \code{zooreg} class objects. There are two main advantages:
\enumerate{
\item Non-numeric columns get removed instead causing coercion issues.
\item If an index is present, the returned \code{zooreg} object retains an index retrievable using \code{\link[=tk_index]{tk_index()}}.
}

The \code{select} argument is used to select subsets
of columns from the incoming data.frame.
The \code{date_var} can be used to specify the column with the date index.
If \code{date_var = NULL}, the date / date-time column is interpreted.
Optionally, the \code{order.by} argument from the underlying \code{xts::xts()} function can be used.
The user must pass a vector of dates or date-times if \code{order.by} is used.
Only columns containing numeric data are coerced.
\emph{At a minimum, a \code{frequency} and a \code{start} should be specified.}

For non-data.frame object classes (e.g. \code{xts}, \code{zoo}, \code{timeSeries}, etc) the objects are coerced
using \code{zoo::zooreg()}.

\code{tk_zooreg_} is a nonstandard evaluation method.
}
\examples{
### tibble to zooreg: Comparison between tk_zooreg() and zoo::zooreg()
data_tbl <- tibble::tibble(
    date = seq.Date(as.Date("2016-01-01"), by = 1, length.out = 5),
    x    = rep("chr values", 5),
    y    = cumsum(1:5),
    z    = cumsum(11:15) * rnorm(1))

# zoo::zooreg: Values coerced to character; Result does not retain index
data_zooreg <- zoo::zooreg(data_tbl[,-1], start = 2016, freq = 365)
data_zooreg                # Numeric values coerced to character
rownames(data_zooreg)      # NULL, no dates retained

# tk_zooreg: Only numeric columns get coerced; Result retains index as rownames
data_tk_zooreg <- tk_zooreg(data_tbl, start = 2016, freq = 365)
data_tk_zooreg             # No inadvertent coercion to character class

# timekit index
tk_index(data_tk_zooreg, timekit_idx = FALSE)   # Regularized index returned
tk_index(data_tk_zooreg, timekit_idx = TRUE)    # Original date index returned

### Using select and date_var
tk_zooreg(data_tbl, select = y, date_var = date, start = 2016, freq = 365)


### NSE: Enables programming
select   <- "y"
date_var <- "date"
tk_zooreg_(data_tbl, select = select, date_var = date_var, start = 2016, freq = 365)

}
\seealso{
\code{\link[=tk_tbl]{tk_tbl()}}, \code{\link[=tk_xts]{tk_xts()}}, \code{\link[=tk_zoo]{tk_zoo()}}, \code{\link[=tk_ts]{tk_ts()}}
}
