% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durSummary.R
\name{durSummary}
\alias{durSummary}
\title{Summary for Date Duration Data}
\usage{
durSummary(df, start, end, group=NA, timeunit="days")
}
\arguments{
\item{df}{Data frame containing start and end dates.}

\item{start}{Column in df for start dates.}

\item{end}{Column in df for end dates.}

\item{group}{Column in df for groups. Default NA.}

\item{timeunit}{Unit of time to be used in plots. \code{"day(s)","week(s)","month(s)","quarter(s)","semiannual", "halfyear", "half-year", "semi-annual", "year(s)"}}
}
\description{
Returns summary statistics for date duration data (for each group if \code{group} is provided)
}
\details{
1 year = 365.25 days, 1 month = 30.42 days, 1 year = 52.14 weeks
}
\examples{
durSummary(life_exp, start="Birth", end="Death", group="Country", timeunit="years")
}
\author{
Dahee Lee
}
\seealso{
\code{\link{durPlot}}, \code{\link{durCalc}}
}

