% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_mutate.R
\name{time_mutate}
\alias{time_mutate}
\title{A time based extension to \code{dplyr::mutate()}.}
\usage{
time_mutate(
  data,
  time = NULL,
  ...,
  time_by = NULL,
  from = NULL,
  to = NULL,
  time_type = c("auto", "duration", "period"),
  include_interval = FALSE,
  .by = NULL,
  .keep = c("all", "used", "unused", "none"),
  time_floor = FALSE,
  week_start = getOption("lubridate.week.start", 1),
  roll_month = "preday",
  roll_dst = "pre"
)
}
\arguments{
\item{data}{A data frame.}

\item{time}{Time variable.}

\item{...}{Additional variables to include.}

\item{time_by}{Time unit. \cr
Must be one of the three:
\itemize{
\item string, specifying either the unit or the number and unit, e.g
\code{time_by = "days"} or \code{time_by = "2 weeks"}
\item named list of length one, the unit being the name, and
the number the value of the list, e.g. \code{list("days" = 7)}.
For the vectorized time functions, you can supply multiple values,
e.g. \code{list("days" = 1:10)}.
\item Numeric vector. If time_by is a numeric vector and x is not a date/datetime,
then arithmetic is used, e.g \code{time_by = 1}.
}}

\item{from}{Time series start date.}

\item{to}{Time series end date.}

\item{time_type}{If "auto", \code{periods} are used for
the time expansion when days, weeks, months or years are specified,
and \code{durations}
are used otherwise.}

\item{include_interval}{Logical. If \code{TRUE} then
a column "interval" of the form \verb{time_min <= x < time_max} is added
showing the time interval in which the respective counts belong to.
The rightmost interval will always be closed.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.keep}{Control which columns are retained.
See \code{?dplyr::mutate} for more details.}

\item{time_floor}{Should \code{from} be floored to the nearest unit specified
through the \code{time_by}
argument? This is particularly useful for starting
sequences at the beginning of a week or month for example.}

\item{week_start}{day on which week starts following ISO conventions - 1
means Monday (default), 7 means Sunday.
This is only used when \code{floor_date = TRUE}.}

\item{roll_month}{Control how impossible dates are handled when
month or year arithmetic is involved.
Options are "preday", "boundary", "postday", "full" and "NA".
See \code{?timechange::time_add} for more details.}

\item{roll_dst}{See \code{?timechange::time_add} for the full list of details.}
}
\value{
A \code{data.frame} with added columns.
}
\description{
This works much the same as \code{dplyr::mutate()}, except that
you can supply an additional \code{time} argument to allow for
aggregating time to a higher unit.

Currently, this does \bold{not} support
filling in missing gaps in time. \cr
Use \code{time_count()} or \code{time_complete()}
before using this if you believe there may be gaps in time.
}
\examples{
library(timeplyr)
library(dplyr)
library(lubridate)
library(nycflights13)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
# Works the same way as mutate()
identical(flights \%>\%
            mutate(across(where(is.numeric), mean)),
          flights \%>\%
            time_mutate(time = NULL,
                        across(where(is.numeric), mean)))
# Like the other time_ functions, it allows for an additional time variable to
# aggregate by
flights \%>\%
  time_mutate(time = across(time_hour, as_date),
              time_by = "month", .keep = "none",
              include_interval = TRUE) \%>\%
  distinct()
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
