% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_mean.R
\name{arithmetic_mean}
\alias{arithmetic_mean}
\alias{geometric_mean}
\alias{harmonic_mean}
\title{Unweighted & weighted arithmetic, geometric and harmonic mean}
\usage{
arithmetic_mean(x, weights = NULL, na.rm = TRUE, ...)

geometric_mean(x, weights = NULL, na.rm = TRUE, ...)

harmonic_mean(x, weights = NULL, na.rm = TRUE, ...)
}
\arguments{
\item{x}{\link{numeric} Vector.}

\item{weights}{\link{numeric} Vector of weights. \cr
Default is \code{NULL} which performs an unweighted mean.}

\item{na.rm}{\link{logical} Value (Default is \code{TRUE}).}

\item{...}{Further arguments passed to \code{collapse::fmean}.}
}
\value{
\code{numeric(min(length(x), 1))}.
}
\description{
Convenience functions for fast unweighted and weighted mean calculations.
}
