% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsum.R
\name{gsum}
\alias{gsum}
\alias{gmean}
\alias{gmin}
\alias{gmax}
\alias{gsd}
\alias{gvar}
\alias{gmode}
\alias{gmedian}
\alias{gfirst}
\alias{glast}
\alias{gnobs}
\title{Grouped statistical functions.}
\usage{
gsum(x, g = NULL, na.rm = TRUE, ...)

gmean(x, g = NULL, na.rm = TRUE, ...)

gmin(x, g = NULL, na.rm = TRUE, ...)

gmax(x, g = NULL, na.rm = TRUE, ...)

gsd(x, g = NULL, na.rm = TRUE, ...)

gvar(x, g = NULL, na.rm = TRUE, ...)

gmode(x, g = NULL, na.rm = TRUE, ...)

gmedian(x, g = NULL, na.rm = TRUE, ...)

gfirst(x, g = NULL, na.rm = TRUE, ...)

glast(x, g = NULL, na.rm = TRUE, ...)

gnobs(x, g = NULL, ...)
}
\arguments{
\item{x}{An atomic vector.}

\item{g}{Group IDs passed directly to \code{collapse::GRP()}.
This can be a vector, list or data frame.}

\item{na.rm}{Should \code{NA} values be removed? Default is \code{TRUE}.}

\item{...}{Additional parameters passed on to the collapse package
equivalents, \code{fsum()}, \code{fmean()}, \code{fmin()}, \code{fmax()},
\code{fsd()}, \code{fvar()}, \code{fmode()}, \code{fmedian()}, \code{ffirst()}, \code{flast()} and
\code{fnobs()}}
}
\value{
A vector the same length as \code{x}.
}
\description{
These functions are wrappers around the collapse equivalents
but always return a vector the same length and same order as x.\cr
They all accept group IDs for grouped calculations.
}
\examples{
library(timeplyr)
library(dplyr)
library(ggplot2)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
# Dplyr
iris \%>\%
  mutate(mean = mean(Sepal.Length), .by = Species)
# Timeplyr
iris \%>\%
  mutate(mean = gmean(Sepal.Length, g = Species))

# One can utilise pick() to specify multiple groups
mpg \%>\%
  mutate(mean = gmean(displ, g = pick(manufacturer, model)))

# Alternatively you can create a unique ID for each group
mpg \%>\%
  add_group_id(manufacturer, model) \%>\%
  mutate(mean = gmean(displ, g = group_id))

# Another example

iris \%>\%
  add_group_id(Species, .name = "g") \%>\%
  mutate(min = gmin(Sepal.Length, g = g),
         max = gmax(Sepal.Length, g = g),
         sum = gsum(Sepal.Length, g = g),
         mean = gmean(Sepal.Length, g = g)) \%>\%
  # The below is equivalent to above
  mutate(min2 = min(Sepal.Length),
         max2 = max(Sepal.Length),
         sum2 = sum(Sepal.Length),
         mean2 = mean(Sepal.Length),
         .by = Species) \%>\%
  distinct(Species,
           min, min2,
           max, max2,
           sum, sum2,
           mean, mean2)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
