% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_lag.R
\name{time_lag}
\alias{time_lag}
\title{Time-lagged values}
\usage{
time_lag(
  x,
  k = 1L,
  time = seq_along(x),
  g = NULL,
  time_type = getOption("timeplyr.time_type", "auto"),
  roll_month = getOption("timeplyr.roll_month", "preday"),
  roll_dst = getOption("timeplyr.roll_dst", "boundary")
)
}
\arguments{
\item{x}{Vector.}

\item{k}{Lag size, must be one of the following:
\itemize{
\item string, e.g \code{"day"} or \code{"2 weeks"}
\item lubridate duration or period object, e.g. \code{days(1)} or \code{ddays(1)}.
\item named list of length one, e.g. \code{list("days" = 7)}.
\item Numeric vector, e.g. \code{7}.
}}

\item{time}{(Optional) time index. \cr
Can be a \code{Date}, \code{POSIXt}, \code{numeric}, \code{integer},
\code{yearmon}, or \code{yearqtr} vector.}

\item{g}{Grouping object passed directly to \code{collapse::GRP()}.
This can for example be a vector or data frame.}

\item{time_type}{If "auto", \code{periods} are used for
the time expansion when lubridate periods are specified or when
days, weeks, months or years are specified,
and \code{durations} are used otherwise.}

\item{roll_month}{Control how impossible dates are handled when
month or year arithmetic is involved.
Options are "preday", "boundary", "postday", "full" and "NA".
See \code{?timechange::time_add} for more details.}

\item{roll_dst}{See \code{?timechange::time_add} for the full list of details.}
}
\value{
A vector of \code{length(x)} lagged by a specified time unit.
}
\description{
Time-lagged values
}
\examples{
library(timeplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
x <- 1:10
t <- time_seq(Sys.Date(), len = 10, time_by = "3 days")

dplyr::lag(x)
time_lag(x)
time_lag(x, time = t, k = "3 days")

# No values exist at t-1 days
time_lag(x, time = t, k = 1)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
