% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics-tk_time_series_cv_plan.R
\name{tk_time_series_cv_plan}
\alias{tk_time_series_cv_plan}
\title{Time Series Resample Plan Data Preparation}
\usage{
tk_time_series_cv_plan(.rset)
}
\arguments{
\item{.rset}{A time series resample specification of of either \code{rolling_origin}
or \code{time_series_cv} class.}
}
\description{
The \code{tk_time_series_cv_plan()} function provides a simple interface to
prepare a time series resample specification (\code{rset}) of either \code{rolling_origin}
or \code{time_series_cv} class.
}
\details{
\strong{Resample Set}

A resample set is an output of the \code{timetk::time_series_cv()} function or the
\code{rsample::rolling_origin()} function.
}
\examples{
library(tidyverse)
library(tidyquant)
library(rsample)
library(timetk)

FB_tbl <- FANG \%>\%
    filter(symbol == "FB") \%>\%
    select(symbol, date, adjusted)

resample_spec <- time_series_cv(
    FB_tbl,
    initial = 150, assess = 50, skip = 50,
    cumulative = FALSE,
    lag = 30,
    slice_limit = n())

resample_spec \%>\% tk_time_series_cv_plan()

}
\seealso{
\itemize{
\item \code{\link[=time_series_cv]{time_series_cv()}} and \code{\link[rsample:rolling_origin]{rsample::rolling_origin()}} - Functions used to create
time series resample specfications.
\item \code{\link[=plot_time_series_cv_plan]{plot_time_series_cv_plan()}} - The plotting function used for visualizing the
time series resample plan.
}
}
