% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-step_diff.R
\name{step_diff}
\alias{step_diff}
\alias{tidy.step_diff}
\title{Create a differenced predictor}
\usage{
step_diff(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  lag = 1,
  difference = 1,
  log = FALSE,
  prefix = "diff_",
  columns = NULL,
  skip = FALSE,
  id = rand_id("diff")
)

\method{tidy}{step_diff}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Defaults to "predictor"}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{lag}{A vector of positive integers identifying which lags (how far back)
to be included in the differencing calculation.}

\item{difference}{The number of differences to perform.}

\item{log}{Calculates log differences instead of differences.}

\item{prefix}{A prefix for generated column names, default to "diff_".}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_diff} object.}
}
\value{
An updated version of \code{recipe} with the
new step added to the sequence of existing steps (if any).
}
\description{
\code{step_diff} creates a \emph{specification} of a recipe step that
will add new columns of differenced data. Differenced data will
include NA values where a difference was induced.
These can be removed with \code{\link[=step_naomit]{step_naomit()}}.
}
\details{
The step assumes that the data are already \emph{in the proper sequential
order} for lagging.
}
\examples{
library(tidyverse)
library(tidyquant)
library(recipes)
library(timetk)


FANG_wide <- FANG \%>\%
    select(symbol, date, adjusted) \%>\%
    pivot_wider(names_from = symbol, values_from = adjusted)


# Make and apply recipe ----

recipe_diff <- recipe(~ ., data = FANG_wide) \%>\%
  step_diff(FB, AMZN, NFLX, GOOG, lag = 1:3, difference = 1) \%>\%
  prep()

recipe_diff \%>\% bake(FANG_wide)


# Get information with tidy ----

recipe_diff \%>\% tidy()

recipe_diff \%>\% tidy(1)

}
\seealso{
Time Series Analysis:
\itemize{
\item Engineered Features: \code{\link[=step_timeseries_signature]{step_timeseries_signature()}}, \code{\link[=step_holiday_signature]{step_holiday_signature()}}, \code{\link[=step_fourier]{step_fourier()}}
\item Diffs & Lags \code{\link[=step_diff]{step_diff()}}, \code{\link[recipes:step_lag]{recipes::step_lag()}}
\item Smoothing: \code{\link[=step_slidify]{step_slidify()}}, \code{\link[=step_smooth]{step_smooth()}}
\item Variance Reduction: \code{\link[=step_box_cox]{step_box_cox()}}
\item Imputation: \code{\link[=step_ts_impute]{step_ts_impute()}}, \code{\link[=step_ts_clean]{step_ts_clean()}}
\item Padding: \code{\link[=step_ts_pad]{step_ts_pad()}}
}

Remove NA Values:
\itemize{
\item \code{\link[recipes:step_naomit]{recipes::step_naomit()}}
}

Main Recipe Functions:
\itemize{
\item \code{\link[recipes:recipe]{recipes::recipe()}}
\item \code{\link[recipes:prep.recipe]{recipes::prep.recipe()}}
\item \code{\link[recipes:bake.recipe]{recipes::bake.recipe()}}
}
}
