% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-tk_make_holiday_sequences.R
\name{tk_make_holiday_sequence}
\alias{tk_make_holiday_sequence}
\alias{tk_make_weekend_sequence}
\alias{tk_make_weekday_sequence}
\title{Make daily Holiday and Weekend date sequences}
\usage{
tk_make_holiday_sequence(
  start_date,
  end_date,
  calendar = c("NYSE", "LONDON", "NERC", "TSX", "ZURICH"),
  skip_values = NULL,
  insert_values = NULL
)

tk_make_weekend_sequence(start_date, end_date)

tk_make_weekday_sequence(
  start_date,
  end_date,
  remove_weekends = TRUE,
  remove_holidays = FALSE,
  calendar = c("NYSE", "LONDON", "NERC", "TSX", "ZURICH"),
  skip_values = NULL,
  insert_values = NULL
)
}
\arguments{
\item{start_date}{Used to define the starting date for date sequence generation.
Provide in "YYYY-MM-DD" format.}

\item{end_date}{Used to define the ending date for date sequence generation.
Provide in "YYYY-MM-DD" format.}

\item{calendar}{The calendar to be used in Date Sequence calculations for Holidays
from the \code{timeDate} package.
Acceptable values are: \code{"NYSE"}, \code{"LONDON"}, \code{"NERC"}, \code{"TSX"}, \code{"ZURICH"}.}

\item{skip_values}{A daily date sequence to skip}

\item{insert_values}{A daily date sequence to insert}

\item{remove_weekends}{A logical value indicating whether or not to
remove weekends (Saturday and Sunday) from the date sequence}

\item{remove_holidays}{A logical value indicating whether or not to
remove common holidays from the date sequence}
}
\value{
A vector containing future dates
}
\description{
Make daily Holiday and Weekend date sequences
}
\details{
\strong{Start and End Date Specification}
\itemize{
\item Accept shorthand notation (i.e. \code{tk_make_timeseries()} specifications apply)
\item Only available in Daily Periods.
}

\strong{Holiday Sequences}

\code{tk_make_holiday_sequence()} is a wrapper for various holiday calendars from the \code{timeDate} package,
making it easy to generate holiday sequences for common business calendars:
\itemize{
\item New York Stock Exchange: \code{calendar = "NYSE"}
\item Londo Stock Exchange: \code{"LONDON"}
\item North American Reliability Council: \code{"NERC"}
\item Toronto Stock Exchange: \code{"TSX"}
\item Zurich Stock Exchange: \code{"ZURICH"}
}

\strong{Weekend and Weekday Sequences}

These simply populate
}
\examples{
library(dplyr)

# Set max.print to 50
options_old <- options()$max.print
options(max.print = 50)


# ---- HOLIDAYS & WEEKENDS ----

# Business Holiday Sequence
tk_make_holiday_sequence("2017-01-01", "2017-12-31", calendar = "NYSE")

tk_make_holiday_sequence("2017", calendar = "NYSE") # Same thing as above (just shorter)

# Weekday Sequence
tk_make_weekday_sequence("2017", "2018", remove_holidays = TRUE)

# Weekday Sequence + Removing Business Holidays
tk_make_weekday_sequence("2017", "2018", remove_holidays = TRUE)


# ---- COMBINE HOLIDAYS WITH MAKE FUTURE TIMESERIES FROM EXISTING ----
# - A common machine learning application is creating a future time series data set
#   from an existing

# Create index of days that FB stock will be traded in 2017 based on 2016 + holidays
FB_tbl <- FANG \%>\% dplyr::filter(symbol == "FB")

holidays <- tk_make_holiday_sequence(
    start_date = "2016",
    end_date   = "2017",
    calendar   = "NYSE")

weekends <- tk_make_weekend_sequence(
    start_date = "2016",
    end_date   = "2017")

# Remove holidays and weekends with skip_values
# We could also remove weekends with inspect_weekdays = TRUE
FB_tbl \%>\%
    tk_index() \%>\%
    tk_make_future_timeseries(length_out       = 366,
                              skip_values      = c(holidays, weekends))


options(max.print = options_old)

}
\seealso{
\itemize{
\item Intelligent date or date-time sequence creation: \code{\link[=tk_make_timeseries]{tk_make_timeseries()}}
\item Holidays and weekends: \code{\link[=tk_make_holiday_sequence]{tk_make_holiday_sequence()}}, \code{\link[=tk_make_weekend_sequence]{tk_make_weekend_sequence()}}, \code{\link[=tk_make_weekday_sequence]{tk_make_weekday_sequence()}}
\item Make future index from existing: \code{\link[=tk_make_future_timeseries]{tk_make_future_timeseries()}}
}
}
