% Generated by roxygen2 (4.0.2): do not edit by hand
\name{timma}
\alias{timma}
\title{Main function for the timma package}
\usage{
timma(x, y, sp = 1, max_k = 5, filtering = FALSE, class = 2,
  averaging = "one.sided", weighted = FALSE, verbosity = FALSE,
  use = "observed")
}
\arguments{
\item{x}{a drug-target interaction matrix. Row names are drug names and column names are target names.}

\item{y}{a normalized drug sensitivity vector.}

\item{sp}{an integer to specify the starting point for the sffs search algorithm. The number cannot be larger than the total number of targets in the drug-target interaction data.
By default, the starting point is the first target, namely, sp = 1.}

\item{max_k}{an integer to specify the maximal number of targets that can be selected by the sffs algorithm. In practice it is advised to keep it under 10
as the number of sensitivities to be predicted will increase exponentially. By default, max_k = 5.}

\item{filtering}{a logical parameter to determine whether the targets should be filtered before the model selection.
By default, the value is FALSE, meaning that all the available targets will be considered in the model selection.
If the value is TRUE, those targets that are negatively correlated with the drug sensitivity data will be removed.}

\item{class}{an integer to specify the number of classes in the drug-target interaction data. For a binary drug-target
interaction data, class = 2. For a multi-class drug-target interaction data, class should be the number of classes.}

\item{averaging}{a parameter to specify which one of the averaging algorithms will be applied in the model construction.
By default, averaging = "one.sided", which is the original model construction algorithm. When averaging = "two.sided",
a modified averaging algorithm will be used. These two variants only differ for the case where the minimization and
maximization rules are not simultaneously satisfied. For example, for a queried target set if the supersets but not the
subsets can be found in the training data, the one.sided algorithm will take the prediction from the averages on the
supersets sensitivities using the minimization rule. The two.sided algorithm, however, will lower the predicted
sensitivity by averaging it with 0, which is the theoretical lower boundary of the sensitivities that could be
obtained in the subsets.}

\item{weighted}{When averaging = "weighted", the similarity between the queried target set and
its subsets/supersets is considered as a weight factor in the averaging, such that those related target
sets will be more weighted in the final predictions.}

\item{verbosity}{a boolean value to decide if the information should be displayed. If it is TRUE, the information
will be displayed while the model is running. Otherwise, the information will not be displayed. By default, it is
FALSE.}

\item{use}{When use = "observed", the true drug sensitivity data will be used for drawing target inhibition network.
When use = "predicted", the predicted drug sensitivity data will be used for drawing target inhibition network.}
}
\value{
Three output files are saved as '.csv' files:
\item{selectedTarget.csv}{ a matrix contains the selected target set and its inhibition configurations for each drug.
The actual drug sensitivity and the predicted LOO sensitivity are listed as additional columns.}
\item{predictedSensitivities.csv}{a matrix of predicted sensitivities for all the possible target inhibition configurations
 derived using the model construction algorithm.}
\item{predictedScoring.csv}{a list of drug combinations ranked by their synergy scores, currently derived from three synergy models:
(a) Multiplicative; (b) Additive; (c) Highest single agent.}

A target inhibition network is constructed and drawn.
}
\description{
Target inhibition inference using maximization and minimization averaging
}
\examples{
\dontrun{
data(tyner_interaction_binary)
data(tyner_sensitivity)
median_sensitivity<-tyner_sensitivity[, 1]
results<-timma(tyner_interaction_binary, median_sensitivity)
}
}
\author{
Liye He \email{liye.he@helsinki.fi}
}
\references{
Tang J, Karhinen L, Xu T, Szwajda A, Yadav B, Wennerberg K, Aittokallio T.
Target inhibition networks: predicting selective combinations of druggable targets to block cancer
survival pathways. PLOS Computational Biology 2013; 9: e1003226.
}

