      SUBROUTINE MARKOVF(N,LAGH3,ID,CYY0,K,NH,JAW,AW1,B1,ICONT,
cx     *IDD,IR,IJ,IK,IPQ,G,A1,A,B,VD,IQM,BM,AU,ZZ,C0,AICD,TMP,IER,
     *IDD,IR,IJ,IK,IPQ,G,A1,A,B,VD,IQM,BM,AU,ZZ,C0,AICD,
     *MJ3,MJ4,MJ6,MJ7)
C
      INCLUDE 'timsac_f.h'
C
cc	PROGRAM MARKOV
C     PROGRAM 74.2.2. MAXIMUM LIKELIHOOD COMPUTATION OF MARKOVIAN MODEL
C-----------------------------------------------------------------------
C     ** DESIGNED BY H. AKAIKE, THE INSTITUTE OF STATISTICAL MATHEMATICS
C     ** PROGRAMMED BY E. ARAHATA, THE INSTITUTE OF STATISTICAL MATHEMAT
C	  TOKYO
C     ** DATE OF THE LATEST REVISION: DECEMBER 6, 1978
C     ** THIS PROGRAM WAS ORIGINALLY PUBLISHED IN
C	 "TIMSAC-74 A TIME SERIES ANALYSIS AND CONTROL PROGRAM PACKAGE(1
C	 BY H. AKAIKE, E. ARAHATA AND T. OZAKI, COMPUTER SCIENCE MONOGRA
C	 NO.5, MARCH 1975, THE INSTITUTE OF STATISTICAL MATHEMATICS
C     ** FOR THE BASIC THEORY SEE "CANONICAL CORRELATION ANALYSIS OF TIM
C	 AND THE USE OF AN INFORMATION CRITERION" BY H. AKAIKE, IN
C	 "SYSTEM IDENTIFICATION: ADVANCES AND CASE STUDIES" R. K. MEHRA
C	 D. G. LAINIOTIS EDS. ACADEMIC PRESS, NEW YORK, 1976
C-----------------------------------------------------------------------
C     IN THIS PROGRAM THE MATRICES A,B,C, STAND FOR TRANSITION MATRIX (F
C     INPUT MATRIX (G), OUTPUT MATRIX (H), RESPECTIVELY.
C
C     THE INPUTS REQUIRED ARE AS FOLLOWS:
C     (N,LAGH0,ID0):
C	  N, LENGTH OF ORIGINAL DATA
C	  LAGH0, MAXIMUM LAG OF COVARIANCE
C	  ID0, DIMENSION OF Y(I)
C     (CYY(I)(I=0,LAGH0): COVARIANCE MATRIX SEQUENCE OF Y(I). CYY(I) ARE
C			 THE OUTPUTS OF THE PROGRAM MULCOR OF TIMSAC AND
C			 ARE USED AS THE INPUT TO THE PROGRAM CANOCA OF
C			 TIMSAC-74. FOR THE CONSTRUCTION OF CYY(I),
C			 SEE PROGRAM CANOCA.
C     THE OUTPUTS OF PROGRAM CANACA:
C	  (ID,K):
C	      ID, DIMENSION OF THE TIME SERIES Y(I) (NOT GREATER THAN 5)
C	      K, DIMENSION OF THE STATE VECTOR (NOT GREATER THAN 10)
C	  (NH(I))(I=1,K): STRUCTURAL CHARACTERISTIC VECTOR
C	  (AW(I))(I=1,IAW): INITIAL ESTIMATE OF THE VECTOR OF FREE
C			   PARAMETERS IN F (=A)
C	  B(I,J)(I=1,ID+1;J=1,ID): INITIAL ESTIMATES OF THE FREE
C				   PARAMETERS IN G (=B)
C     ICONT: OUTPUT CONTROL
C	  = 0, FOR AR-MA COEFFICIENTS
C	  = 1, FOR SIMCON INPUT
C	  = 2, FOR BOTH
C
C     THE OUTPUTS OF THIS PROGRAM ARE;
C     THE MAXIMUM LIKELIHOOD ESTIMATES
C	  (ID,K):
C	  (NH(I))(I=1,K):
C	  (AW(I))(I=1,IAW):
C	  (B(I,J))(I=1,ID+1;J=1,ID):
C     AND THE OUTPUTS TO BE USED BY THE PROGRAMS PRDCTR AND SIMCON
C	  (ID,Q,Q-1):
C	  (B(I,J,L))(I,J=1,ID,L=1,Q): AR-COEFFICIENT MATRICES
C	  AND, WHEN ICONT=1 OR 2,
C	  (W(I,J,L))(I,J=1,ID,L=1,Q-1): IMPULSE RESPONSE MATRICES
C	  AND, WHEN ICONT=0 OR 1,
C	  (A(I,J,L))(I,J=1,ID;L=1,Q-1): MA-COEFFICIENT MATRICES
C     AND
C	  (C0(I,J))(I,J=1,ID): INNOVATION COVARIANCE.
C
C     COMMENTS:
C     ***** IT IS ASSUMED THAT ID0=ID. OTHERWISE USE THE LOADING
C     PROGRAM OF CYY(I) USED BY THE PROGRAM CANOCA.
C     ***** THE INPUT TO THIS PROGRAM IS NOT LIMITED TO THE OUTPUT OF
C     PROGRAM CANOCA. THE FINAL DECISION ON THE STRUCTURAL
C     CHARACTERISTIC VECTOR NH(I) (I=1,K) SHOULD BE MADE BY COMPARING
C     THE AIC VALUES OF VARIOUS POSSIBLE CHOICES OF NH WITH
C     THE MINIMUM AIC OF THE AR-MODEL.
C     ***** TO KEEP THE ACCURACY OF COMPUTATION THE COMPONENTS OF Y(I)
C     SHOULD BE SCALED SO THAT THE VARIANCES ARE NEARLY EQUAL TO EACH
C     OTHER.
C     *****
C
cc      !DEC$ ATTRIBUTES DLLEXPORT :: MARKOVF
C
      IMPLICIT REAL*8(A-H,O-Z)
cc	COMMON /COM10/CYY1
cc	COMMON /COM50/VD
cc	COMMON /COM60/IDD,IR
cc	COMMON /COM61/IJ,IK
cc	COMMON /COM70/NH
cc	COMMON /COM80/A
cc	COMMON /COM81/B
cc	COMMON /COM82/AW
      COMMON /COM99/ISWR
cc	COMMON /COM87/ICONT
      COMMON /COM101/AICO
      COMMON /COM102/KSWR
cc	COMMON /COM199/AICD
cc	DIMENSION CYY1(160,5,5)
cc	DIMENSION A(10,10),B(10,5),OB(10,5)
cc	DIMENSION VD(50,50)
cc	DIMENSION X(100),C0(5,5),G(100),R(100)
cc	DIMENSION AW(50),OAW(50)
cc	DIMENSION NH(10),IDD(10),IR(10),IJ(5),IK(5)
      DIMENSION CYY0(LAGH3,ID,ID),CYY1(MJ3,ID,ID)
      DIMENSION A(K,K),B(K,ID),OB(K,ID)
      DIMENSION VD(MJ4,MJ4)
      DIMENSION X(MJ4),C0(ID,ID),G(MJ4),R(MJ4)
      DIMENSION AW(JAW),OAW(JAW)
      DIMENSION A1(K,K),B1(K,ID),AW1(JAW)
      DIMENSION NH(K),IDD(K),IR(K),IJ(ID),IK(ID)
      DIMENSION BM(ID,ID,MJ6),AU(ID,ID,MJ7),ZZ(ID,ID,MJ7)
C
      DIMENSION O(50,ID,K),Q(50,K,ID),X1(50,K,K),X2(50,ID,ID)
      DIMENSION CXY1(100,ID,ID),CXX1(51,ID,ID),CXV1(51,ID,K)
C
cx      INTEGER*1  TMP(1)
cx      CHARACTER  CNAME*80
C
C     INPUT / OUTPUT DATA FILE OPEN
cc	CHARACTER(100) DFNAM
cc	CALL SETWND
cc	DFNAM='markov.out'
cc	CALL FLOPN3(DFNAM,NFL)
cc	IF (NFL.EQ.0) GO TO 999
c
cx      IER=0
cx      LU=3
cx      DO 10 I = 1,80
cx   10 CNAME(I:I) = ' '
cx      I = 1
cx      IFG = 1
cx      DO WHILE( (IFG.EQ.1) .AND. (I.LE.80) )
cx	   IF ( TMP(I).NE.ICHAR(' ') ) THEN
cx            CNAME(I:I) = CHAR(TMP(I))
cx            I = I+1
cx         ELSE
cx            IFG = 0
cx         END IF
cx      END DO
cx      IF ( I.GT.1 ) THEN
cx         IFG = 1
cx         OPEN (LU,FILE=CNAME,IOSTAT=IVAR)
cx         IF (IVAR .NE. 0) THEN
cxcx            WRITE(*,*) ' ***  markov temp FILE OPEN ERROR :',CNAME,IVAR
cx            IER=IVAR
cx            IFG=0
cx         END IF
cx      END IF
C
C     ABSOLUTE DIMENSIONS USED FOR SUBROUTINE CALL
cc	MJ1=10
cc	MJ2=5
      CST0=0.0D-00
      CST1=1.0D-00
      CST05=0.00005D-00
C     INITIAL INPUT
cc	READ(5,1) N,LAGH0,ID
cc	LAGH3=LAGH0+1
C     COVARIANCE INPUT
      DO 1010 II=1,ID
cc	READ(5,1) IR0,IC0
cc	READ(5,2) (CYY1(I,IR0,IC0),I=1,LAGH3)
cc	IF(II.EQ.1) GO TO 1010
cc	IIM1=II-1
cc	DO 1011 JJ=1,IIM1
cc	READ(5,1) IR1,IC1
cc	READ(5,2) (CYY1(I,IR1,IC1),I=1,LAGH3)
cc	READ(5,1) IR2,IC2
cc	READ(5,2) (CYY1(I,IR2,IC2),I=1,LAGH3)
cc 1011 CONTINUE
      DO 1010 JJ=1,ID
	 DO 1008 KK=1,MJ3
          CYY1(KK,JJ,II)=0
 1008  CONTINUE
	 DO 1009 KK=1,LAGH3
	    CYY1(KK,JJ,II)=CYY0(KK,JJ,II)
 1009	 CONTINUE
 1010 CONTINUE
C
cc	READ(5,1) ID,K
cc	READ(5,1) (NH(I),I=1,K)
cc	CALL SUBIDR(K,ID,IAW)
      CALL SUBIDR(NH,IDD,IR,IJ,IK,K,ID,IAW)
C     INITIAL PRINT OUT
cc	WRITE(6,900)
cc	WRITE(6,901)
cc	WRITE(6,903) ID,N,LAGH0
cc	WRITE(6,904) K,IAW
C
C     A MATRIX ARRANGEMENT
cc	READ(5,2) (AW(I),I=1,IAW)
      DO 4009 I=1,JAW
	 AW(I)=AW1(I)
 4009 CONTINUE
      JS=0
      DO 4010 I=1,K
      DO 4010 J=1,K
cc 4010 A(I,J)=CST0
      A(I,J)=CST0
      A1(I,J)=CST0
 4010 CONTINUE
      DO 4011 I=1,K
      IF(IDD(I).NE.0) GO TO 4012
      JJ=IR(I)
      A(I,JJ)=CST1
      A1(I,JJ)=CST1
      GO TO 4011
 4012 JL=IR(I)
      DO 4013 J=1,JL
      JS=JS+1
cc 4013 A(I,J)=AW(JS)
      A(I,J)=AW(JS)
      A1(I,J)=AW(JS)
 4013 CONTINUE
 4011 CONTINUE
cc	DO 4020 I=1,ID
cc	DO 4019 J=1,ID
cc 4019 B(I,J)=CST0
cc 4020 B(I,I)=CST1
      IDP1=ID+1
cc	DO 4021 I=IDP1,K
cc 4021 READ(5,2) (B(I,J),J=1,ID)
      DO 4020 I=1,K
	 DO 4019 J=1,ID
	    B(I,J)=B1(I,J)
 4019	 CONTINUE
 4020 CONTINUE
cc	READ(5,1) ICONT
C     NH(I) PRINT OUT
cc	WRITE(6,4300) (I,I=1,K)
cc	WRITE(6,4310) (NH(I),I=1,K)
C     IDD(I),IR(I) PRINT OUT
cc	WRITE(6,3610) (IDD(I),I=1,K)
cc	WRITE(6,3620) (IR(I),I=1,K)
C     IJ(I),IK(I) PRINT OUT
cc	WRITE(6,3650) (IJ(I),I=1,ID)
cc	WRITE(6,3660) (IK(I),I=1,ID)
cc	WRITE(6,6000)
cc	WRITE(6,6001)
cc	WRITE(6,6002)
cc	WRITE(6,6004)
cc	WRITE(6,6006)
cc	WRITE(6,6008)
cc	WRITE(6,6100)
C     A,B PRINT OUT
cc	WRITE(6,52)
cc	DO 180 I=1,K
cc  180 WRITE(6,2200) I,(A(I,J),J=1,K)
cc	WRITE(6,53)
cc	DO 181 I=1,K
cc  181 WRITE(6,2200) I,(B(I,J),J=1,ID)
cc	WRITE(6,340)
cc	DO 360 I=1,IAW
cc  360 WRITE(6,351) I,AW(I)
      ISWR=0
      ISWRO=0
C
C     IPQ=TOTAL NUMBER OF FREE PARAMETERS
  400 IPQ=IAW+(K-ID)*ID
      AIPQ=IPQ
      IDP1=ID+1
cc	WRITE(6,411) ISWRO
cx      IF (IFG.NE.0) WRITE(LU,411) ISWRO
  411 FORMAT(/1H ,'ISWRO=',I5)
      DO 500 I=1,IAW
  500 X(I)=AW(I)
      JJ=IAW
      DO 510 I=IDP1,K
      DO 510 J=1,ID
      JJ=JJ+1
  510 X(JJ)=B(I,J)
C     INNOVATION COVARIANCE MATRIX (CXX0(0)) AND GRADIENT G(X)
C     OF LOG(DET.CXX0(0)) COMPUTATION
      KSWR=0
      IG=0
cc	CALL C0GR(X,C0,G,M,L,K,ID,IAW,IPQ,MJ1,MJ2,IG)
      CALL C0GR(CYY1,MJ3,B,AW,IAW,NH,IDD,IR,IJ,IK,X,C0,G,M,L,K,ID,IPQ,
cx     *                MJ4,IG,O,Q,X1,X2,CXY1,CXX1,CXV1,IFG,LU)
     *                MJ4,IG,O,Q,X1,X2,CXY1,CXX1,CXV1)
      DO 1500 I=1,IAW
 1500 X(I)=AW(I)
      JJ=IAW
      DO 1510 I=IDP1,K
      DO 1510 J=1,ID
      JJ=JJ+1
 1510 X(JJ)=B(I,J)
cc	WRITE(6,340)
cc	DO 1360 I=1,IAW
cc 1360 WRITE(6,351) I,AW(I)
cc	WRITE(6,53)
cc	DO 2181 I=1,K
cc 2181 WRITE(6,2200) I,(B(I,J),J=1,ID)
cx      IF (IFG.NE.0) THEN
cx	 WRITE(LU,340)
cx	 DO 1360 I=1,IAW
cx 1360	 WRITE(LU,351) I,AW(I)
cx	 WRITE(LU,53)
cx	 DO 2181 I=1,K
cx 2181	 WRITE(LU,2200) I,(B(I,J),J=1,ID)
cx      END IF
C
C     HESSIAN COMPUTATION
cc	CALL SUBHES(M,L,K,ID,IAW,MJ1,MJ2)
      CALL SUBHES(CYY1,IJ,IK,VD,M,L,K,ID,IAW,MJ3,MJ4,O,Q,X1,X2,
     *            CXY1,CXX1,CXV1)
      IF(ISWRO.GT.0) GO TO 2651
cc	WRITE(6,2000)
cc	DO 2100 I=1,IPQ
cc 2100 WRITE(6,2200) I,(VD(I,J),J=1,IPQ)
cx      IF (IFG.NE.0) THEN
cx	   WRITE(LU,2000)
cx	 DO 2100 I=1,IPQ
cx 2100	 WRITE(LU,2200) I,(VD(I,J),J=1,IPQ)
cx	 WRITE(LU,'(/)')
cx      END IF
C     (INVERSE OF HESSIAN) COMPUTATION
cc 2651 CALL MATINV(IPQ)
cxx 2651 CALL MATINV(IPQ,VD,MJ4,IFG,LU)
 2651 CALL MATINV(IPQ,VD,MJ4)
      IF(ISWRO.GT.0) GO TO 2650
cc	WRITE(6,2500)
cc	DO 2600 I=1,IPQ
cc 2600 WRITE(6,2200) I,(VD(I,J),J=1,IPQ)
cx      IF (IFG.NE.0) THEN
cx	 WRITE(LU,2500)
cx	 DO 2600 I=1,IPQ
cx 2600	 WRITE(LU,2200) I,(VD(I,J),J=1,IPQ)
cx      END IF
C
C     CORRECTION R(X)=V*G(X) COMPUTATION
 2650 DO 100 I=1,IPQ
      SUM=CST0
      DO 110 J=1,IPQ
  110 SUM=SUM+VD(I,J)*G(J)
  100 R(I)=SUM
C     ORIGINAL PARAMETER VALUES
      DO 2655 I=1,IAW
 2655 OAW(I)=AW(I)
      DO 2656 I=IDP1,K
      DO 2656 J=1,ID
 2656 OB(I,J)=B(I,J)
C     DAVIDON'S PROCEDURE
cc	CALL SUBDAV(X,C0,G,R,N,K,ID,IAW,IPQ,MJ1,MJ2,ISWRO)
      CALL SUBDAV(CYY1,MJ3,B,AW,IAW,NH,IDD,IR,IJ,IK,VD,X,C0,G,R,N,K,
cx     * ID,IPQ,AICD,MJ1,MJ4,ISWRO,O,Q,X1,X2,CXY1,CXX1,CXV1,IFG,LU)
     * ID,IPQ,AICD,MJ1,MJ4,ISWRO,O,Q,X1,X2,CXY1,CXX1,CXV1)
      ISFIN=0
      IF(ISWRO.GE.20) GO TO 599
      IF (ISWRO.EQ.0) GO TO 599
      DO 150 I=1,IAW
      IF(DABS(OAW(I)-X(I)).GE.CST05) GO TO 153
  150 CONTINUE
      JJ=IAW
      DO 151 I=IDP1,K
      DO 151 J=1,ID
      JJ=JJ+1
      IF(DABS(OB(I,J)-X(JJ)).GE.CST05) GO TO 153
  151 CONTINUE
      GO TO 599
  153 ISFIN=1
C
C
  599 DO 600 I=1,IAW
  600 AW(I)=X(I)
      IDP1=ID+1
      JJ=IAW
      DO 610 I=IDP1,K
      DO 610 J=1,ID
      JJ=JJ+1
  610 B(I,J)=X(JJ)
      IF(ISFIN.EQ.0) GO TO 1450
      GO TO 400
C
C     FINAL PRINT OUT
cc 1450 WRITE(6,1460)
cc 1460 FORMAT(//1H ,'FINAL RESULTS')
 1450 CONTINUE
C
C     GRADIENT PRINT OUT
cc	WRITE(6,1400)
cc	CALL SUBVCP(G,IPQ)
C
C     A ARRANGEMENT
cc	CALL SUBA(K,ID,MJ1,MJ2,IAW)
      CALL SUBA(A,AW,IJ,IK,K,ID,IAW)
C     A, B PRINT OUT
cc	WRITE(6,52)
cc	DO 1180 I=1,K
cc 1180 WRITE(6,2200) I,(A(I,J),J=1,K)
cc	WRITE(6,53)
cc	DO 1181 I=1,K
cc 1181 WRITE(6,2200) I,(B(I,J),J=1,ID)
C     VD(I,J) PRINT OUT
cc	WRITE(6,2550)
cc	DO 2800 I=1,IPQ
cc 2800 WRITE(6,2200) I,(VD(I,J),J=1,IPQ)
C     A, B PUNCH OUT
cc	WRITE(7,1) ID,K
cc	WRITE(7,1) (NH(I),I=1,K)
cc	WRITE(7,2) (AW(I),I=1,IAW)
cc	DO 410 I=IDP1,K
cc  410 WRITE(7,2) (B(I,J),J=1,ID)
cc	CALL ARMACO(ID,K,MJ1,MJ2)
      CALL ARMACO(A,B,AW,IAW,NH,IDD,IR,IJ,IK,ID,ICONT,K,BM,AU,ZZ,
     *            IQM,MJ6,MJ7)
C     INNOVATION VARIANCE PUNCH OUT
cc	DO 460 I=1,ID
cc  460 WRITE(7,2) (C0(I,J),J=1,ID)
cc	WRITE(6,6610)
cc	DO 6620 I=1,ID
cc 6620 WRITE(6,2200) I,(C0(I,J),J=1,ID)
cc	WRITE(6,3609) AICD
C
cc	CALL FLCLS3(NFL)
  999 CONTINUE
cc	STOP
cx      IF (IFG.NE.0) CLOSE(LU)
      RETURN
    1 FORMAT(16I5)
    2 FORMAT(4D20.10)
   52 FORMAT(/1H ,'A(I,J)')
   53 FORMAT(/1H ,'B(I,J)')
  340 FORMAT(/1H ,'AW(I)')
  351 FORMAT(1H ,I5,D17.5)
  900 FORMAT(/1H ,'PROGRAM 74.2.2. MARKOV')
  901 FORMAT(/1H ,'MAXIMUM LIKELIHOOD COMPUTATION OF ',
     A'MULTIVARIATE MARKOVIAN MODEL.')
  903 FORMAT(/1H ,'DIMENSION OF Y(I) (ID)=',I5,5X,'DATA LENGTH (N)=',
     AI5,5X,'MAXIMUM LAG OF COVARIANCE (LAGH0)=',I5)
  904 FORMAT(1H ,'DIMENSION OF THE STATE VECTOR (K)=',I5,5X,
     A'TOTAL NUMBER OF FREE PARAMETERS (IAW)=',I5)
 1400 FORMAT(/1H ,'GRADIENT')
 4300 FORMAT(/1H ,5X,'I',16I5)
 4310 FORMAT(1H ,1X,'NH(I)',16I5)
 3610 FORMAT(1H ,'IDD(I)',16I5)
 3620 FORMAT(1H ,1X,'IR(I)',16I5)
 3650 FORMAT(1H ,1X,'IJ(I)',16I5)
 3660 FORMAT(1H ,1X,'IK(I)',16I5)
 2000 FORMAT(///1H ,'HESSIAN')
cc 2200 FORMAT(/1H ,I5,10D12.5,/(1H ,5X,10D12.5))
 2200 FORMAT(/I5,5(1X,D12.5)/5X,5(1X,D12.5))
 2500 FORMAT(///1H ,'INVERSE OF HESSIAN')
 2550 FORMAT(///1H ,'DAVIDON VARIANCE')
 6000 FORMAT(/1H ,'COMMENTS:')
 6001 FORMAT(1H ,'NH(I) IS THE STRUCTURAL CHARACTERISTIC VECTOR.')
 6002 FORMAT(1H ,'ID(I)=1 MEANS THAT THE I-TH ROW OF A CONTAINS FREE',
     A' PARAMETERS.')
 6004 FORMAT(1H ,'IR(I) DENOTES THE POSITION OF THE LAST NON-ZERO',
     A' ELEMENT WITHIN THE I-TH ROW OF A.')
 6006 FORMAT(1H ,'IJ(I) DENOTES THE POSITION OF THE I-TH NON-TRIVIAL',
     A' ROW WITHIN A.')
 6008 FORMAT(1H ,'IK(I) DENOTES THE NUMBER OF FREE PARAMETERS WITHIN',
     A' THE I-TH NON-TRIVIAL ROW OF A.')
 6100 FORMAT(/1H ,'INITIAL ESTIMATES')
 6610 FORMAT(/1H ,'INNOVATION VARIANCE')
 3609 FORMAT(/1H ,'AIC=N*LOG(DET(CXX0))+2.0*IPQ=',D12.5)
      END
C
cc	SUBROUTINE C0GR(X,C0,GR,M,L,K,ID,IAW,IPQ,MJ1,MJ2,IG)
      SUBROUTINE C0GR(CYY1,MJ3,B,AW,IAW,NH,IDD,IR,IJ,IK,X,C0,GR,M,L,K,
cx     *                   ID,IPQ,MJ4,IG,O,Q,X1,X2,CXY1,CXX1,CXV1,IFG,LU)
     *                   ID,IPQ,MJ4,IG,O,Q,X1,X2,CXY1,CXX1,CXV1)
C     THIS SUBROUTINE COMPUTES THE INNOVATION MATRIX CXX(0) AND
C     THE GRADIENT OF LOG(DET CXX(0))
      IMPLICIT REAL*8(A-H,O-Z)
cc	COMMON /COM81/B
cc	COMMON /COM82/AW
      COMMON /COM102/KSWR
cc	DIMENSION CYY1(160,5,5),B(10,5),AW(50)
cc	DIMENSION IDD(10),IR(10),IJ(5),IK(5)
cc	DIMENSION X(100),C0(10,10),GR(100)
      DIMENSION CYY1(MJ3,ID,ID),B(K,ID),AW(IAW)
      DIMENSION NH(K),IDD(K),IR(K),IJ(ID),IK(ID)
      DIMENSION X(MJ4),C0(ID,ID),GR(MJ4)
      DIMENSION O(50,ID,K),Q(50,K,ID),X1(50,K,K),X2(50,ID,ID)
      DIMENSION CXY1(100,ID,ID),CXX1(51,ID,ID),CXV1(51,ID,K)
C
      DO 600 I=1,IAW
  600 AW(I)=X(I)
      IDP1=ID+1
      JJ=IAW
      DO 610 I=IDP1,K
      DO 610 J=1,ID
      JJ=JJ+1
  610 B(I,J)=X(JJ)
C     IMPULSE RESPONSE COMPUTATION
      IG1=IG
      IG2=IG
cc	CALL NSUBX1(K,ID,M,MJ1,MJ2,IG1)
cc	CALL NSUBX2(K,ID,KK,MJ1,MJ2,IG2)
cx      CALL NSUBX1(B,AW,IAW,NH,IDD,IR,IJ,K,ID,M,IG1,X1,IFG,LU)
cx      CALL NSUBX2(B,AW,IAW,IDD,IR,K,ID,KK,IG2,Q,X2,IFG,LU)
      CALL NSUBX1(B,AW,IAW,NH,IDD,IR,IJ,K,ID,M,IG1,X1)
      CALL NSUBX2(B,AW,IAW,IDD,IR,K,ID,KK,IG2,Q,X2)
      IG=IG1+IG2
      IF(KSWR.EQ.0) GO TO 620
      IF(IG.NE.0) GO TO 1000
  620 L=KK
C     CXY1(LS) LS=0,M+L+1 COMPUTATION
cc	CALL SBCXY1(M,L,ID,MJ2)
      CALL SBCXY1(CYY1,MJ3,M,L,ID,X2,CXY1)
C     CXX1(NS) NS=0,M+1.
cc	CALL SUBCXX(C0,M,KK,ID,MJ2)
      CALL SUBCXX(C0,M,KK,ID,X2,CXY1,CXX1)
C     CXV1(MS) MS=0,M+1 COMPUTATION
cc	CALL GCXV1(M,L,K,ID,MJ1,MJ2)
      CALL GCXV1(M,L,K,ID,Q,CXY1,CXV1)
C     O(NS) COMPUTATION
cc	CALL NSUBO(C0,K,ID,M,MJ1,MJ2)
      CALL NSUBO(C0,K,ID,M,O,X1)
C     GRADIENT GA AND GB COMPUTATION
cc	CALL GRAD(GR,M,K,ID,IAW,IPQ,MJ1,MJ2)
cx      CALL GRAD(IJ,IK,GR,M,K,ID,IAW,IPQ,MJ4,O,CXX1,CXV1,IFG,LU)
      CALL GRAD(IJ,IK,GR,M,K,ID,IAW,IPQ,MJ4,O,CXX1,CXV1)
 1000 KSWR=1
      RETURN
      END
C
cc	SUBROUTINE NSUBX1(K,ID,M,MJ1,MJ2,IG1)
cx      SUBROUTINE NSUBX1(B,AW,IAW,NH,IDD,IR,IJ,K,ID,M,IG1,X1,IFG,LU)
      SUBROUTINE NSUBX1(B,AW,IAW,NH,IDD,IR,IJ,K,ID,M,IG1,X1)
C     THIS SUBROUTINE COMPUTES THE IMPULSE RESPONSE OF
C     (INVERSE OF (C*(INVERSE OF PHAI)*B))*C*
C     (INVERSE OF PHAI). PHAI = INVERSE OF (I-A*EXP(-I*2*PI*F)).
C     C*(INVERSE OF PHAI): FROM V TO Y
C     INVERSE OF (C*(INVERSE OF PHAI)*B): FROM Y TO X
C     K: DIMENSION OF THE STATE VECTOR
C     ID: DIMENSION OF Y(I)
C     M: UPPER LIMIT OF THE NUMBER OF IMPULSE RESPONSES.
C
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM15/X1
cc	COMMON /COM60/IDD,IR
cc	COMMON /COM81/B
cc	COMMON /COM82/AW
      COMMON /COM99/ISWR
cc	DIMENSION IDD(10),IR(10)
cc	DIMENSION AW(50),B(10,5)
      DIMENSION NH(K),IDD(K),IR(K),IJ(ID)
      DIMENSION AW(IAW),B(K,ID)
cc      DIMENSION X1(50,10,10)
cc	DIMENSION V(10,10),AV(10,10)
cc	DIMENSION X(5,10),Y(5,10),U(10,10)
cc	DIMENSION AU(10,10)
      DIMENSION X1(50,K,K)
      DIMENSION V(K,K),AV(K,K)
      DIMENSION X(ID,K),Y(ID,K),U(K,K)
      DIMENSION AU(K,K)
C
C
C
      CST0=0.0D-00
      CST1=1.0D-00
      ITINP=0
C     V(0)=I
  199 DO 200 I=1,K
      DO 210 J=1,K
  210 V(I,J)=CST0
  200 V(I,I)=CST1
C
C     C=(I,0)
C     I=(ID,ID), 0:(ID,(K-ID))
C     Y(0)=C
      DO 300 I=1,ID
      DO 310 J=1,K
  310 Y(I,J)=CST0
  300 Y(I,I)=CST1
C
C     X(0)=Y(0)
C     X:(ID,K)
      DO  400  I=1,ID
      DO 400 J=1,K
      X(I,J)=Y(I,J)
  400 X1(1,I,J)=X(I,J)
C
C     U(0)=(B,0)
C     B:(K,ID), 0:(K,K-ID)
      DO 500 I=1,K
      DO 590 J=1,K
  590 U(I,J)=CST0
      DO 510 J=1,ID
  510 U(I,J)=B(I,J)
  500 CONTINUE
C
      CONSTM=0.1D-00
      CONSTD=0.0001D-00
      LH=6
      IH=0
      NS=1
      NSM1=NS-1
      IF(IG1.EQ.0) GO TO 270
      CONSTD=0.01D-00
      IG1=0
  270 IF(ISWR.GE.1) GO TO 280
      CONSTD=0.01D-00
C
C     V(NS+1)=A*V(NS)+Z(NS+1)
cc  280 CALL SUBAWZ(V,AV,K,K,MJ1,MJ1)
  280 CALL SUBAWZ(AW,IAW,IDD,IR,V,AV,K,K)
      DO 230 I=1,K
      DO 230 J=1,K
  230 V(I,J)=AV(I,J)
C
C     Y(NS)=C*V(NS) COMPUTATION
C     Y:(ID,K), C:(ID,K), V:(K,K)
      DO 320 I=1,ID
      DO 320 J=1,K
  320 Y(I,J)=V(I,J)
C
C     X(NS)=Y(NS)-C*A*U(NS-1) COMPUTATION
cc	CALL SUBAWZ(U,AU,K,K,MJ1,MJ1)
      CALL SUBAWZ(AW,IAW,IDD,IR,U,AU,K,K)
      DO 450 I=1,ID
      DO 450 J=1,K
  450 X(I,J)=Y(I,J)-AU(I,J)
      DO 452 I=1,ID
      DO 452 J=1,K
  452 X1(NS+1,I,J)=X(I,J)
C
C     U(NS)=A*U(NS-1)+B*X(NS) COMPUTATION
      DO 180 I=1,K
      DO 180 J=1,K
      SUM=CST0
      DO 181 JJ=1,ID
  181 SUM=SUM+B(I,JJ)*X(JJ,J)
  180 U(I,J)=AU(I,J)+SUM
C
C     MAXIMUM ABSOLUTE VALUE OF X(I,J) SEARCH
cc	CALL SUBMAX(X,XMAX,ID,K,MJ2,MJ1)
      CALL SUBMAX(X,XMAX,ID,K)
C
      IF(XMAX.GE.CONSTD) GO TO 740
      IH=IH+1
      IF(IH.LT.LH) GO TO 720
      GO TO 760
  740 IH=0
  720 IF(NS.GE.49) GO TO 770
      NS=NS+1
      GO TO 280
  770 M=49
cc	WRITE(6,2000) M,XMAX
cc	WRITE( 6,2001 )
cx      IF (IFG.NE.0) THEN
cx	 WRITE( LU,2000) M,XMAX
cx	 WRITE( LU,2001 )
cx 2001	 FORMAT( 1H ,'WARNING : INCOMPLETE CONVERGENCE' )
cx      END IF
      IG1=1
      IF(ISWR.GE.1) GO TO 771
      IG1=0
C     RESCALING FOR A FEASIBLE INITIAL
      IF(ITINP.GE.50) GO TO 771
      ITINP=ITINP+1
cc	CALL RESCAL(K,ID)
cx      CALL RESCAL(B,AW,IAW,NH,IDD,IR,IJ,IK,K,ID,IFG,LU)
      CALL RESCAL(B,AW,IAW,NH,IDD,IR,IJ,IK,K,ID)
cc	WRITE(6,2330) ITINP
cx      IF (IFG.NE.0) WRITE(LU,2330) ITINP
 2330 FORMAT(//1H ,'ITINP=',I5)
      GO TO 199
  771 ISWR=ISWR+1
      RETURN
  760 M=NS-LH
cc	WRITE(6,2000) M,XMAX
cx      IF (IFG.NE.0) WRITE(LU,2000) M,XMAX
 2000 FORMAT(1H ,'M=',I5,5X,'XMAX1=',D12.5)
      ISWR=ISWR+1
      RETURN
      END
C
cc	SUBROUTINE NSUBX2(K,ID,KK,MJ1,MJ2,IG2)
cx      SUBROUTINE NSUBX2(B,AW,IAW,IDD,IR,K,ID,KK,IG2,Q,X2,IFG,LU)
      SUBROUTINE NSUBX2(B,AW,IAW,IDD,IR,K,ID,KK,IG2,Q,X2)
C     THIS SUBROUTINE COMPUTES X2(NS,I,J) AND U(NS),
C     NS=0,1,2,...,L(=KK).
C
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM3/X2
cc	COMMON /COM60/IDD,IR
cc	COMMON /COM81/B
cc	COMMON /COM82/AW
cc      COMMON /COM2/Q
      COMMON /COM99/ISWR
cc      DIMENSION Q(50,10,5)
cc	DIMENSION IDD(10),IR(10)
cc      DIMENSION X2(50,5,5)
cc	DIMENSION AW(50),B(10,5)
cc	DIMENSION U(10,5)
cc	DIMENSION XX(5,5),AU(10,5)
      DIMENSION Q(50,K,ID)
      DIMENSION IDD(K),IR(K)
      DIMENSION X2(50,ID,ID)
      DIMENSION AW(IAW),B(K,ID)
      DIMENSION U(K,ID)
      DIMENSION XX(ID,ID),AU(K,ID)
C
C     X(0)=I
C     X:(ID,ID)
      CST0=0.0D-00
      CST1=1.0D-00
      DO 200 I=1,ID
      DO 210 J=1,ID
  210 X2(1,I,J)=CST0
  200 X2(1,I,I)=CST1
C
C     U(0)=B
C     U:(K,ID), B(K,ID)
      DO 300 I=1,K
      DO 300 J=1,ID
  300 U(I,J)=B(I,J)
C
      CONSTD=0.0001D-00
      LH=6
      IH=0
      NS=1
      NSM1=NS-1
      KMD = K - ID
      IDP1 = ID + 1
      DO 191 I=1,KMD
      IPD = I + ID
      DO 191 J=1,ID
  191 Q(1,I,J) = U(IPD,J)
      IF(IG2.EQ.0) GO TO 270
      CONSTD=0.01D-00
      IG2=0
  270 IF(ISWR.GE.2) GO TO 280
      CONSTD=0.01D-00
C
C     X(NS)=-C*A*U(NS-1) COMPUTATION
cc  280 CALL SUBAWZ(U,AU,K,ID,MJ1,MJ2)
  280 CALL SUBAWZ(AW,IAW,IDD,IR,U,AU,K,ID)
      DO 450 I=1,ID
      DO 450 J=1,ID
  450 XX(I,J)=-AU(I,J)
C
C     U(NS)=A*U(NS-1)+B*X(NS) COMPUTATION
      DO 180 I=1,K
      DO 180 J=1,ID
      SUM=CST0
      DO 181 JJ=1,ID
  181 SUM=SUM+B(I,JJ)*XX(JJ,J)
  180 U(I,J)=AU(I,J)+SUM
      DO 190 I=1,KMD
      IPD = I + ID
      DO 190 J=1,ID
  190 Q(NS+1,I,J) = U(IPD,J)
      DO 530 I=1,ID
      DO 530 J=1,ID
  530 X2(NS+1,I,J)=XX(I,J)
C
C     MAXIMUM ABSOLUTE VALUE OF XX(I,J) SEARCH
cc	CALL SUBMAX(XX,XMAX,ID,ID,MJ2,MJ2)
      CALL SUBMAX(XX,XMAX,ID,ID)
C
      IF(XMAX.GE.CONSTD) GO TO 740
      IH=IH+1
      IF(IH.LT.LH) GO TO 720
      GO TO 760
  740 IH=0
  720 IF(NS.GE.49) GO TO 770
      NS=NS+1
      GO TO 280
  770 KK=49
cc	WRITE(6,2200) KK,XMAX
cc	WRITE( 6,2300 )
cx      IF (IFG.NE.0) THEN
cx	 WRITE( LU,2200) KK,XMAX
cx	 WRITE( LU,2300 )
cx 2300	 FORMAT( 1H ,'WARNING : X2 INCOMPLETE CONVERGENCE' )
cx      END IF
      IG2=1
      RETURN
  760 KK=NS-LH
cc	WRITE(6,2200) KK,XMAX
cx      IF (IFG.NE.0) WRITE(LU,2200) KK,XMAX
 2200 FORMAT(1H ,'KK=',I5,5X,'XMAX2=',D12.5)
      RETURN
      END
C
cc	SUBROUTINE NSUBO(C0,K,ID,M,MJ1,MJ2)
      SUBROUTINE NSUBO(C0,K,ID,M,O,X1)
C     THIS SUBROUTINE COMPUTES O(NS).
C     O(NS)=(INVERSE OF C0)*X1(NS)
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM15/X1
cc      COMMON /COM1/O
cc      DIMENSION X1(50,10,10),O(50,5,10)
cc	DIMENSION C0(5,5),C0I(5,5)
cc	DIMENSION X(5,10),OO(5,10)
      DIMENSION X1(50,K,K),O(50,ID,K)
      DIMENSION C0(ID,ID),C0I(ID,ID)
      DIMENSION X(ID,K),OO(ID,K)
C
C     INVERSE OF C0 COMPUTATION
      DO 600 I=1,ID
      DO 600 J=1,ID
  600 C0I(I,J)=C0(I,J)
cc	CALL INVDET(C0I,C0DET,ID,MJ2)
      CALL INVDET(C0I,C0DET,ID,ID)
C
      MP1=M+1
      DO 1000 NS=1,MP1
      DO 610 J=1,K
      DO 610 I=1,ID
  610 X(I,J)=X1(NS,I,J)
C     O(NS)=(INVERSE OF C0)*X(NS) COMPUTATION
cc	CALL MULPLY(C0I,X,OO,ID,ID,K,MJ2,MJ2,MJ1)
      CALL MULPLY(C0I,X,OO,ID,ID,K)
      DO 620 I=1,ID
      DO 620 J=1,K
  620 O(NS,I,J)=OO(I,J)
      NSM1=NS-1
 1000 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SUBMAX(XX,XMAX,IA,IB,MJ6,MJ7)
      SUBROUTINE SUBMAX(XX,XMAX,IA,IB)
C     MAXIMUM ABSOLUTE VALUE OF XX(I,J) SEARCH
      IMPLICIT REAL*8(A-H,O-Z)
cc	DIMENSION XX(MJ6,MJ7)
      DIMENSION XX(IA,IB)
      XMAX=0.0D-00
      DO 709 I=1,IA
      DO 710 J=1,IB
      T=DABS(XX(I,J))
      IF(XMAX.GE.T) GO TO 710
      XMAX=T
  710 CONTINUE
  709 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE GRAD(GR,M,K,ID,IAW,IPQ,MJ1,MJ2)
cx      SUBROUTINE GRAD(IJ,IK,GR,M,K,ID,IAW,IPQ,MJ4,O,CXX1,CXV1,IFG,LU)
      SUBROUTINE GRAD(IJ,IK,GR,M,K,ID,IAW,IPQ,MJ4,O,CXX1,CXV1)
C     THIS SUBROUTINE COMPUTES GRADIENT (GA AND GB).
C     GA=-2.0*(O(0)'*CXV1(1)+O(1)'*CXV1(2)+O(2)'*CXV1(3)+...+O(NSL)'*CXV
C     1(1+NSL)).
C     GB=-2.0*(O(0)'*CXX1(0)+O(1)'*CXX1(1)+O(2)'*CXX1(2)+...+O(NSL)'*CXX
C     1(NSL)).
C
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM1/O
cc      COMMON /COM12/CXX1
cc      COMMON /COM14/CXV1
cc      COMMON/COM61/IJ,IK
c      DIMENSION O(50,5,10),CXX1(51,5,5),CXV1(51,5,10)
cc	DIMENSION OO(10,5),CXX(5,5),CXV(5,10)
cc	DIMENSION ZA(10,10),ZZA(10,10),ZB(10,5),ZZB(10,5)
cc	DIMENSION GR(100)
cc	DIMENSION ZAW(50)
cc	DIMENSION IJ(5),IK(5)
      DIMENSION O(50,ID,K),CXX1(51,ID,ID),CXV1(51,ID,K)
      DIMENSION OO(K,ID),CXX(ID,ID),CXV(ID,K)
      DIMENSION ZA(K,K),ZZA(K,K),ZB(K,ID),ZZB(K,ID)
      DIMENSION GR(MJ4),ZAW(MJ4)
      DIMENSION IJ(ID),IK(ID)
C
C
C     GA, GB COMPUTATION
      CST0=0.0D-00
      CST1=1.0D-00
      CST2=2.0D-00
      DO 210 I=1,K
      DO 208 J=1,K
  208 ZA(I,J)=CST0
      DO 209 J=1,ID
  209 ZB(I,J)=CST0
  210 CONTINUE
      MP1=M+1
      DO 300 NSP1=1,MP1
      NSP2=NSP1+1
      DO 310 I=1,K
      DO 310 J=1,ID
      OO(I,J)=O(NSP1,J,I)
  310 CXV(J,I)=CXV1(NSP2,J,I)
      DO 320 I=1,ID
      DO 320 J=1,ID
  320 CXX(I,J)=CXX1(NSP1,I,J)
cc	CALL MULPLY(OO,CXV,ZZA,K,ID,K,MJ1,MJ2,MJ1)
cc	CALL MATADL(ZA,ZZA,K,K,MJ1,MJ1)
cc	CALL MULPLY(OO,CXX,ZZB,K,ID,ID,MJ1,MJ2,MJ2)
cc	CALL MATADL(ZB,ZZB,K,ID,MJ1,MJ2)
      CALL MULPLY(OO,CXV,ZZA,K,ID,K)
      CALL MATADL(ZA,ZZA,K,K)
      CALL MULPLY(OO,CXX,ZZB,K,ID,ID)
      CALL MATADL(ZB,ZZB,K,ID)
  300 CONTINUE
C     GRADIENT ARRANGEMENT
cc	IKSUM=0
      IKSJ=0
      DO 1300 KS=1,ID
      JL=IK(KS)
      DO 1310 J=1,JL
cc	IKSJ=IKSUM+J
      IKSJ=IKSJ+1
      IJK=IJ(KS)
 1310 ZAW(IKSJ)=ZA(IJK,J)
cc 1300 IKSUM=IKSUM+JL
 1300 CONTINUE
      IAW=IKSJ
      DO 500 I=1,IAW
  500 GR(I)=-CST2*ZAW(I)
C     K>ID
      IDP1=ID+1
      JJ=IAW
      DO 510 I=IDP1,K
      DO 510 J=1,ID
      JJ=JJ+1
  510 GR(JJ)=-CST2*ZB(I,J)
cc	WRITE(6,1400)
cc	CALL SUBVCP(GR,IPQ)
cx      IF (IFG.NE.0) WRITE(LU,1400)
cx      IF (IFG.NE.0) CALL SUBVCP(GR,IPQ,LU)
      RETURN
 1400 FORMAT(/1H ,'GRADIENT')
      END
C
cc	SUBROUTINE SBCXY1(M,L,ID,MJ2)
      SUBROUTINE SBCXY1(CYY1,MJ3,M,L,ID,X2,CXY1)
C     THIS SUBROUTINE COMPUTES CXY1(LS) LS=0,M+1+L.
C     CXY1(LS)=X2(0)*CYY1(LS)+X2(1)*CYY1(LS-1)+X2(2)*CYY1(LS-2)+...
C     +X2(L)*CYY1(LS-L).
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM3/X2
cc	COMMON /COM10/CYY1
cc      COMMON /COM11/CXY1
cc	DIMENSION X2(50,5,5),CYY1(160,5,5),CXY1(100,5,5)
cc	DIMENSION XX(5,5),CYY(5,5),Z(5,5),ZZ(5,5)
      DIMENSION X2(50,ID,ID),CYY1(MJ3,ID,ID),CXY1(100,ID,ID)
      DIMENSION XX(ID,ID),CYY(ID,ID),Z(ID,ID),ZZ(ID,ID)
C
C
      CST0=0.0D-00
      LSL=M+2+L
      LP1=L+1
C
      DO 200 LSP1=1,LSL
      LS=LSP1-1
      DO 209 I=1,ID
      DO 209 J=1,ID
  209 Z(I,J)=CST0
      DO 300 MSP1=1,LP1
      MS=MSP1-1
      DO 310 I=1,ID
      DO 310 J=1,ID
  310 XX(I,J)=X2(MSP1,I,J)
      LMS=LS-MS
      IF(LMS.LT.0) GO TO 319
      LMSP1=LMS+1
      DO 320 I=1,ID
      DO 320 J=1,ID
  320 CYY(I,J)=CYY1(LMSP1,I,J)
      GO TO 340
  319 LMSP1=-LMS+1
      DO 330 I=1,ID
      DO 330 J=1,ID
  330 CYY(I,J)=CYY1(LMSP1,J,I)
cc  340 CALL MULPLY(XX,CYY,ZZ,ID,ID,ID,MJ2,MJ2,MJ2)
cc	CALL MATADL(Z,ZZ,ID,ID,MJ2,MJ2)
  340 CALL MULPLY(XX,CYY,ZZ,ID,ID,ID)
      CALL MATADL(Z,ZZ,ID,ID)
  300 CONTINUE
  280 DO 350 I=1,ID
      DO 350 J=1,ID
  350 CXY1(LSP1,I,J)=Z(I,J)
  200 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SUBCXX(C0,M,KK,ID,MJ2)
      SUBROUTINE SUBCXX(C0,M,KK,ID,X2,CXY1,CXX1)
C     THIS SUBROUTINE COMPUTES CXX1(NS) NS=0,M+1.
C     CXX1(NS)=CXY1(NS)*X2(0)'+CXY1(NS+1)*X2(1)'+CXY1(NS+2)*X2(2)'+...
C     +CXY1(NS+MSL)*X2(MSL)'.
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM3/X2
cc      COMMON /COM11/CXY1
cc      COMMON /COM12/CXX1
cc      DIMENSION X2(50,5,5),CXY1(100,5,5),CXX1(51,5,5)
cc	DIMENSION XX(5,5),CXY(5,5),Z(5,5),ZZ(5,5)
cc	DIMENSION C0(5,5)
      DIMENSION X2(50,ID,ID),CXY1(100,ID,ID),CXX1(51,ID,ID)
      DIMENSION XX(ID,ID),CXY(ID,ID),Z(ID,ID),ZZ(ID,ID)
      DIMENSION C0(ID,ID)
C
C
      CST0=0.0D-00
      NSL=M+2
      KKP1=KK+1
C
      DO 200 NSP1=1,NSL
      NS=NSP1-1
      DO 209 I=1,ID
      DO 209 J=1,ID
  209 Z(I,J)=CST0
      DO 300 MSP1=1,KKP1
      NSPMS1=NS+MSP1
      DO 310 I=1,ID
      DO 310 J=1,ID
      XX(I,J)=X2(MSP1,J,I)
  310 CXY(I,J)=CXY1(NSPMS1,I,J)
cc	CALL MULPLY(CXY,XX,ZZ,ID,ID,ID,MJ2,MJ2,MJ2)
cc	CALL MATADL(Z,ZZ,ID,ID,MJ2,MJ2)
      CALL MULPLY(CXY,XX,ZZ,ID,ID,ID)
      CALL MATADL(Z,ZZ,ID,ID)
  300 CONTINUE
  280 DO 350 I=1,ID
      DO 350 J=1,ID
  350 CXX1(NSP1,I,J)=Z(I,J)
  200 CONTINUE
      DO 400 I=1,ID
      DO 400 J=1,ID
  400 C0(I,J)=CXX1(1,I,J)
      RETURN
      END
C
cc	SUBROUTINE GCXV1(M,L,K,ID,MJ1,MJ2)
      SUBROUTINE GCXV1(M,L,K,ID,Q,CXY1,CXV1)
C     THIS SUBROUTINE COMPUTES CXV1(MS) MS=0,M+1.
C     CXV1(MS)=CXY1(MS)*Q(0)'+CXY1(MS+1)*Q(1)'+...+CXY1(MS+L)*Q(L)'
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM2/Q
cc      COMMON /COM11/CXY1
cc      COMMON /COM14/CXV1
cc      DIMENSION Q(50,10,5),CXY1(100,5,5),CXV1(51,5,10)
cc	DIMENSION QQ(5,10),CXY(5,5),Z(5,10),ZZ(5,10)
      DIMENSION Q(50,K,ID),CXY1(100,ID,ID),CXV1(51,ID,K)
      DIMENSION QQ(ID,K-ID),CXY(ID,ID),Z(ID,K-ID),ZZ(ID,K-ID)
C
C
      CST0=0.0D-00
      MP2=M+2
      LP1=L+1
      KMD = K - ID
      IDP1 = ID + 1
C
      DO 200 MSP1=1,MP2
      MS=MSP1-1
      DO 209 I=1,ID
cc	DO 209 J=1,K
      DO 209 J=1,KMD
  209 Z(I,J)=CST0
      DO 300 NSP1=1,LP1
      MNSP1=MS+NSP1
      DO 210 I=1,ID
      DO 220 J=1,ID
  220 CXY(I,J)=CXY1(MNSP1,I,J)
      DO  230  J=1,KMD
  230 QQ(I,J)=Q(NSP1,J,I)
  210 CONTINUE
cc	CALL  MULPLY ( CXY,QQ,ZZ,ID,ID,KMD,MJ2,MJ2,MJ1 )
cc	CALL  MATADL ( Z,ZZ,ID,KMD,MJ2,MJ1 )
      CALL  MULPLY ( CXY,QQ,ZZ,ID,ID,KMD )
      CALL  MATADL ( Z,ZZ,ID,KMD )
  300 CONTINUE
  280 DO 350 I=1,ID
      DO 349   J=1,ID
  349 CXV1(MSP1,I,J)=CXY1(MSP1,I,J)
      DO 350   J=IDP1,K
      JMD = J - ID
  350 CXV1(MSP1,I,J) = Z(I,JMD)
  200 CONTINUE
      RETURN
      END
C
C
cc	SUBROUTINE  SUBIDR ( K,ID,IAW )
      SUBROUTINE  SUBIDR ( NH,IDD,IR,IJ,IK,K,ID,IAW )
C     CONSTRUCTION OF CHARACTERISTIC VECTORS
cc	COMMON /COM60/IDD,IR
cc	COMMON /COM61/IJ,IK
cc	COMMON /COM70/NH
cc	DIMENSION NH(10),IDD(10),IR(10)
cc	DIMENSION IJ(5),IK(5)
      DIMENSION NH(K),IDD(K),IR(K)
      DIMENSION IJ(ID),IK(ID)
      IAW = 0
      IFP = 0
      DO 100 I=1,K
      IDH = NH(I) + ID
      IF( NH(K) .LT. IDH )	   GO TO 111
      LR=0
      J=I+1
  130 LR=LR+1
      IF(NH(J).LT.IDH) GO TO 110
      IF(NH(J).GT.IDH) GO TO 120
      IDD(I)=0
      IR(I)=I+LR
      GO TO 100
  120 IR(I) = I+ LR - 1
      GO TO 113
  110 J=J+1
      GO TO 130
  111 IR(I) = K
  113 IDD(I) = 1
  112 IFP = IFP + 1
      IJ(IFP) = I
      IK(IFP) = IR(I)
      IAW = IAW + IR(I)
  100 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SUBA(K,ID,MJ1,MJ2,IAW)
      SUBROUTINE SUBA(A,AW,IJ,IK,K,ID,IAW)
C     CONSTRUCTION OF A FROM AW
      IMPLICIT REAL*8(A)
cc	COMMON /COM61/IJ,IK
cc	COMMON /COM80/A
cc	COMMON /COM82/AW
cc	DIMENSION A(10,10),AW(50)
cc	DIMENSION IJ(5),IK(5)
      DIMENSION A(K,K),AW(IAW)
      DIMENSION IJ(ID),IK(ID)
cc	IKSUM=0
      IKSJ=0
      DO 300 KS=1,ID
      JL=IK(KS)
      DO 310 J=1,JL
cc	IKSJ=IKSUM+J
      IKSJ=IKSJ+1
      IJK=IJ(KS)
  310 A(IJK,J)=AW(IKSJ)
cc  300 IKSUM=IKSUM+JL
  300 CONTINUE
      IAW=IKSJ
      RETURN
      END
C
cc	SUBROUTINE SUBAWZ(Z,ZP,K,IC,MJ3,MJ4)
      SUBROUTINE SUBAWZ(AW,IAW,IDD,IR,Z,ZP,K,IC)
C     ZP=A*Z
      IMPLICIT REAL*8(A-H,O-Z)
cc	COMMON /COM60/IDD,IR
cc	COMMON /COM82/AW
cc	DIMENSION AW(50),IDD(10),IR(10)
cc	DIMENSION Z(MJ3,MJ4),ZP(MJ3,MJ4)
      DIMENSION AW(IAW),IDD(K),IR(K)
      DIMENSION Z(K,IC),ZP(K,IC)
      CST0=0.0D-00
      NI=0
      DO 400 I=1,K
      IF(IDD(I).NE.0) GO TO 410
      IRI=IR(I)
      DO 420 JJ=1,IC
  420 ZP(I,JJ)=Z(IRI,JJ)
      GO TO 400
  410 NI0=NI
      NI=NI+IR(I)
      IRI=IR(I)
      DO 430 JJ=1,IC
      SUM=CST0
      DO 440 J=1,IRI
      NI0J=NI0+J
  440 SUM=SUM+AW(NI0J)*Z(J,JJ)
  430 ZP(I,JJ)=SUM
  400 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SUBCM(M,L,K,ID,MJ1,MJ2)
      SUBROUTINE SUBCM(M,L,K,ID,O,CM1)
C     THIS SUBROUTINE COMPUTES CM1(MS).
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM1/O
cc      COMMON /COM15/CM1
cc      DIMENSION O(50,5,10) , CM1(50,10,10)
cc	DIMENSION OO(10,5),XX(5,10),Z(10,10),ZZ(10,10)
      DIMENSION O(50,ID,K),CM1(50,K,K)
      DIMENSION OO(K,ID),XX(ID,K),Z(K,K),ZZ(K,K)
C
C
C     CM1(MS) COMPUTATION
C
      CST0=0.0D-00
      MP1=M+1
      DO 200 MSP1=1,MP1
      MS=MSP1-1
      DO 209 I=1,K
      DO 209 J=1,K
  209 Z(I,J)=CST0
      NSL=M-MS+1
      DO 300 NSP1=1,NSL
      MNSP1=MS+NSP1
      DO 220 I=1,K
      DO 220 J=1,ID
      OO(I,J)=O(NSP1,J,I)
  220 XX(J,I) = CM1(MNSP1,J,I)
cc	CALL MULPLY(OO,XX,ZZ,K,ID,K,MJ1,MJ2,MJ1)
cc	CALL MATADL(Z,ZZ,K,K,MJ1,MJ1)
      CALL MULPLY(OO,XX,ZZ,K,ID,K)
      CALL MATADL(Z,ZZ,K,K)
  300 CONTINUE
      DO 350 I=1,K
      DO 350 J=1,K
  350 CM1(MSP1,I,J)=Z(I,J)
  200 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SUBHES(M,L,K,ID,IAW,MJ1,MJ2)
      SUBROUTINE SUBHES(CYY1,IJ,IK,HS,M,L,K,ID,IAW,MJ3,MJ4,O,Q,CM1,X2,
     *                  CXY1,CXX1,CXV1)
C     THIS SUBROUTINE COMPUTES HESSIAN.
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM61/IJ,IK
cc      COMMON /COM50/HS
cc      COMMON /COM15/CM1
cc      COMMON /COM12/CXX1
cc      COMMON /COM16/CVV1
cc      COMMON /COM19/CXV2
cc      COMMON /COM14/CXV1
cc      DIMENSION CYY1(160,5,5),IJ(5),IK(5)
cc      DIMENSION CXV1(51,5,10)
cc      DIMENSION CM1(50,10,10),CXX1(51,5,5),CVV1(50,10,10)
cc      DIMENSION HS(50,50)
      DIMENSION CYY1(MJ3,ID,ID),IJ(ID),IK(ID)
      DIMENSION CXV1(51,ID,K)
      DIMENSION CM1(50,K,K),CXX1(51,ID,ID),CVV1(50,K,K)
      DIMENSION CXV2(51,ID,K)
      DIMENSION HS(MJ4,MJ4)
      DIMENSION O(50,ID,K),Q(50,K,ID),X2(50,ID,ID)
      DIMENSION CXY1(100,ID,ID),CXY2(50,ID,ID)
C
      CST2=2.0D-00
C     CXY2(MS) MS=0,M-1 COMPUTATION
cc	CALL SBCXY2(M,L,ID,MJ2)
      CALL SBCXY2(CYY1,MJ3,M,L,ID,X2,CXY2)
C     CXV2(MS) MS=0,M-1 COMPUTATION
cc	CALL HCXV2(M,L,K,ID,MJ1,MJ2)
      CALL HCXV2(M,L,K,ID,Q,CXY1,CXY2,CXV2)
C     CM1(MS) MS=0,M COMPUTATION
cc	CALL SUBCM(M,L,K,ID,MJ1,MJ2)
      CALL SUBCM(M,L,K,ID,O,CM1)
C     HESSIAN COMPUTATION
C     HBB COMPUTATION
      MP1=M+1
      IDP1=ID+1
      JJ=IAW
      DO 460 I=IDP1,K
      DO 460 J=1,ID
      JJ=JJ+1
      JJ2=IAW
      DO 1460 I2=IDP1,I
      DO 1460 J2=1,ID
      JJ2=JJ2+1
      SUMBB=CM1(1,I,I2)*CXX1(1,J,J2)
      DO 490 MSP1=2,MP1
  490 SUMBB=SUMBB+CM1(MSP1,I,I2)*CXX1(MSP1,J,J2)+CM1(MSP1,I2,I)*CXX1(MSP
     A1,J2,J)
      HS(JJ,JJ2)=CST2*SUMBB
      HS(JJ2,JJ)=HS(JJ,JJ2)
 1460 CONTINUE
  460 CONTINUE
C
C     HAB COMPUTATION
      IKSJ = 0
      DO 800 KS=1,ID
      JL=IK(KS)
      DO 810 J=1,JL
      IKSJ = IKSJ + 1
      IJK=IJ(KS)
      JJ2=IAW
      DO 860 I2=IDP1,K
      DO 860 J2=1,ID
      JJ2=JJ2+1
      SUMAB=CM1(1,IJK,I2)*CXV1(2,J2,J)
      DO 870 MS=1,M
      MSP1=MS+1
      MSP2=MSP1+1
      SUMAB=SUMAB+CM1(MSP1,IJK,I2)*CXV2(MS,J2,J)+CM1(MSP1,I2,IJK)*CXV1(M
     ASP2,J2,J)
  870 CONTINUE
      HS(IKSJ,JJ2)=CST2*SUMAB
      HS(JJ2,IKSJ)=HS(IKSJ,JJ2)
  860 CONTINUE
  810 CONTINUE
  800 CONTINUE
C
C
C     CYV1,CYV2 COMPUTATION
cc	CALL SBCYV1(M,L,K,ID,MJ1,MJ2)
cc	CALL SBCYV2(L,K,ID,MJ1,MJ2)
      CALL SBCYV1(CYY1,MJ3,M,L,K,ID,Q,CXV1)
      CALL SBCYV2(CYY1,MJ3,L,K,ID,Q,CXV2)
C     CVV1 COMPUTATION
cc	CALL SUBCVV(M,L,K,ID,MJ1,MJ2)
      CALL SUBCVV(M,L,K,ID,Q,CXV1,CVV1,CXV2)
C
C     HAA COMPUTATION
      IKSJ = 0
      DO 310 KS=1,ID
      JL=IK(KS)
      DO 310 J=1,JL
      IKSJ = IKSJ + 1
      IJK=IJ(KS)
      IKSJ2 = 0
      DO 1310 KS2=1,KS
      JL2=IK(KS2)
      DO 1310 J2=1,JL2
      IKSJ2=IKSJ2+1
      IJK2=IJ(KS2)
      SUMAA=CM1(1,IJK,IJK2)*CVV1(1,J,J2)
      DO 440 MSP1=2,MP1
  440 SUMAA=SUMAA+CM1(MSP1,IJK,IJK2)*CVV1(MSP1,J,J2)+CM1(MSP1,IJK2,IJK)*
     ACVV1(MSP1,J2,J)
      HS(IKSJ,IKSJ2)=CST2*SUMAA
      HS(IKSJ2,IKSJ)=HS(IKSJ,IKSJ2)
 1310 CONTINUE
  310 CONTINUE
      RETURN
      END
C
C
cc	SUBROUTINE SUBCVV(M,L,K,ID,MJ1,MJ2)
      SUBROUTINE SUBCVV(M,L,K,ID,Q,CYV1,CVV1,CYV2)
C     THIS SUBROUTINE COMPUTES CVV1(MS) MS=0,M.
C     CVV1(MS)=Q(0)*CYV(MS)+Q(1)*CYV(MS-1)+...+Q(L)*CYV(MS-L)
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM2/Q
cc      COMMON /COM14/ CYV1
cc      COMMON /COM16/ CVV1
cc      COMMON /COM19/ CYV2
cc      DIMENSION Q(50,10,5),CYV1(51,5,10),CVV1(50,10,10)
      DIMENSION Q(50,K,ID),CYV1(51,ID,K),CVV1(50,K,K)
      DIMENSION CYV2(51,ID,K)
cc	DIMENSION QQ(10,5),CXV(5,10),Z(10,10),ZZ(10,10)
      DIMENSION QQ(K-ID,ID),CXV(ID,K),Z(K-ID,K),ZZ(K-ID,K)
C
C
C
      CST0=0.0D-00
      CST1=1.0D-00
C     CVV1(MS) COMPUTATION
      MP1=M+1
      LP1=L+1
      IDP1 = ID + 1
      KMD = K - ID
      DO 200 MSP1=1,MP1
      DO 209 I=1,KMD
      DO 209 J=1,K
  209 Z(I,J)=CST0
      DO 300 LSP1=1,LP1
      DO 210 I=1,KMD
      DO 210 J=1,ID
  210 QQ(I,J)=Q(LSP1,I,J)
      ML=MSP1-LSP1
      IF(ML.LT.0) GO TO 319
      DO 320 I=1,ID
      DO 320 J=1,K
  320 CXV(I,J)=CYV1(ML+1,I,J)
      GO TO 340
  319 ML=-ML
      DO 330 I=1,ID
      DO 330 J=1,K
  330 CXV(I,J)=CYV2(ML+1,I,J)
cc  340 CALL  MULPLY ( QQ,CXV,ZZ,KMD,ID,K,MJ1,MJ2,MJ1 )
cc	CALL  MATADL ( Z,ZZ,KMD,K,MJ1,MJ1 )
  340 CALL  MULPLY ( QQ,CXV,ZZ,KMD,ID,K )
      CALL  MATADL ( Z,ZZ,KMD,K )
  300 CONTINUE
      DO 349   I=1,ID
      DO 349   J=1,K
  349 CVV1(MSP1,I,J)=CYV1(MSP1,I,J)
      DO 350   I=IDP1,K
      DO 350   J=1,K
      IMD = I - ID
  350 CVV1(MSP1,I,J) = Z(IMD,J)
  200 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SBCYV1(M,L,K,ID,MJ1,MJ2)
      SUBROUTINE SBCYV1(CYY1,MJ3,M,L,K,ID,Q,CYV1)
C     THIS SUBROUTINE COMPUTES CYV1(MS) (MS=0,M).
C     CYV1(MS)=CYY1(MS)*Q(0)'+CYY1(MS+1)*Q(1)'+CYY1(MS+2)*Q(2)'+...
C     -CYY1(MS+L)*Q(L)'.
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM2/Q
cc      COMMON /COM10/CYY1
cc      COMMON /COM14/CYV1
cc	DIMENSION Q(50,10,5),CYY1(160,5,5),CYV1(51,5,10)
cc	DIMENSION QQ(5,10),CYY(5,5),Z(5,10),ZZ(5,10)
      DIMENSION Q(50,K,ID),CYY1(MJ3,ID,ID),CYV1(51,ID,K)
      DIMENSION QQ(ID,K-ID),CYY(ID,ID),Z(ID,K-ID),ZZ(ID,K-ID)
C
      CST0=0.0D-00
      MP1=M+1
      LP1=L+1
      IDP1 = ID + 1
      KMD = K - ID
      DO 200 MSP1=1,MP1
      DO 209 I=1,ID
cc	DO 209 J=1,K
      DO 209 J=1,KMD
  209 Z(I,J)=CST0
      DO 300 LSP1=1,LP1
      ML=MSP1+LSP1-1
      DO 210 I=1,ID
      DO 210 J=1,ID
  210 CYY(I,J)=CYY1(ML,I,J)
      DO 220 I=1,ID
      DO 220 J=1,KMD
  220 QQ(I,J)=Q(LSP1,J,I)
cc	CALL  MULPLY ( CYY,QQ,ZZ,ID,ID,KMD,MJ2,MJ2,MJ1 )
cc	CALL  MATADL ( Z,ZZ,ID,KMD,MJ2,MJ1 )
      CALL  MULPLY ( CYY,QQ,ZZ,ID,ID,KMD )
      CALL  MATADL ( Z,ZZ,ID,KMD )
  300 CONTINUE
      DO 350 I=1,ID
      DO 349 J=1,ID
  349 CYV1(MSP1,I,J)=CYY1(MSP1,I,J)
      DO 350 J=IDP1,K
      JMD = J - ID
  350 CYV1(MSP1,I,J)=Z(I,JMD)
  200 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SBCYV2(L,K,ID,MJ1,MJ2)
      SUBROUTINE SBCYV2(CYY1,MJ3,L,K,ID,Q,CYV2)
C     THIS SUBROUTINE COMPUTES CYV2(MS) (MS=-L,0).
C     CYV2(MS)=CYV1(-MS)
C     =CYY1(-MS)*Q(0)'+CYY1(-MS+1)*Q(1)'+CYY1(-MS+2)*Q(2)'+...
C     +CYY1(-MS+L)*Q(L)'.
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM2/Q
cc      COMMON /COM10/CYY1
cc      COMMON /COM19/ CYV2
cc	DIMENSION Q(50,10,5),CYY1(160,5,5),CYV2(51,5,10)
cc	DIMENSION QQ(5,10),CYY(5,5),Z(5,10),ZZ(5,10)
      DIMENSION Q(50,K,ID),CYY1(MJ3,ID,ID),CYV2(51,ID,K)
      DIMENSION QQ(ID,K-ID),CYY(ID,ID),Z(ID,K-ID),ZZ(ID,K-ID)
C
      CST0=0.0D-00
      LP1=L+1
      IDP1 = ID + 1
      KMD = K - ID
      DO 200 MSP1=1,LP1
      DO 209 I=1,ID
cc	DO 209 J=1,K
      DO 209 J=1,KMD
  209 Z(I,J)=CST0
      DO 300 LSP1=1,LP1
      DO 210 I=1,ID
      DO 210 J=1,KMD
  210 QQ(I,J)=Q(LSP1,J,I)
      ML=LSP1-MSP1
      IF(ML.LT.0) GO TO 319
      DO 320 I=1,ID
      DO 320 J=1,ID
  320 CYY(I,J)=CYY1(ML+1,I,J)
      GO TO 340
  319 ML=-ML
      DO 330 I=1,ID
      DO 330 J=1,ID
  330 CYY(I,J)=CYY1(ML+1,J,I)
cc  340 CALL  MULPLY ( CYY,QQ,ZZ,ID,ID,KMD,MJ2,MJ2,MJ1 )
cc	CALL  MATADL ( Z,ZZ,ID,KMD,MJ2,MJ1 )
  340 CALL  MULPLY ( CYY,QQ,ZZ,ID,ID,KMD )
      CALL  MATADL ( Z,ZZ,ID,KMD )
  300 CONTINUE
      DO 350 I=1,ID
      DO 349 J=1,ID
  349 CYV2(MSP1,I,J)=CYY1(MSP1,J,I)
      DO 350 J=IDP1,K
      JMD = J - ID
  350 CYV2(MSP1,I,J)=Z(I,JMD)
  200 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE HCXV2(M,L,K,ID,MJ1,MJ2)
      SUBROUTINE HCXV2(M,L,K,ID,Q,CXY1,CXY2,CXV2)
C     THIS SUBROUTINE COMPUTES CXV2(MS) MS=0,M-1.
C     CXV2(MS)=CXV1(-MS)
C     =CXY1(-MS)*Q(0)'+CXY1(-MS+1)*Q(1)'+...+CXY1(-MS+L)*Q(L)'
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM2/Q
cc      COMMON /COM11/CXY1
cc      COMMON /COM110/CXY2
cc      COMMON /COM19/CXV2
cc      DIMENSION Q(50,10,5),CXY1(100,5,5),CXY2(50,5,5),CXV2(51,5,10)
cc	DIMENSION QQ(5,10),CXY(5,5),Z(5,10),ZZ(5,10)
      DIMENSION Q(50,K,ID),CXY1(100,ID,ID),CXY2(50,ID,ID),CXV2(51,ID,K)
      DIMENSION QQ(ID,K-ID),CXY(ID,ID),Z(ID,K-ID),ZZ(ID,K-ID)
C
      CST0=0.0D-00
      LP1=L+1
      IDP1 = ID + 1
      KMD = K - ID
      DO 200 MSP1=1,M
      DO 209 I=1,ID
cc	DO 209 J=1,K
      DO 209 J=1,KMD
  209 Z(I,J)=CST0
      DO 300 LSP1=1,LP1
      DO 210 I=1,ID
      DO 210 J=1,KMD
  210 QQ(I,J)=Q(LSP1,J,I)
      ML=LSP1-MSP1
      IF(ML.LT.0) GO TO 319
      DO 320 I=1,ID
      DO 320 J=1,ID
  320 CXY(I,J)=CXY1(ML+1,I,J)
      GO TO 340
  319 ML=-ML
      DO 330 I=1,ID
      DO 330 J=1,ID
  330 CXY(I,J)=CXY2(ML+1,I,J)
cc  340 CALL MULPLY ( CXY,QQ,ZZ,ID,ID,KMD,MJ2,MJ2,MJ1 )
cc	CALL  MATADL ( Z,ZZ,ID,KMD,MJ2,MJ1 )
  340 CALL MULPLY ( CXY,QQ,ZZ,ID,ID,KMD )
      CALL  MATADL ( Z,ZZ,ID,KMD )
  300 CONTINUE
      DO 350 I=1,ID
      DO 349 J=1,ID
  349 CXV2(MSP1,I,J)=CXY2(MSP1,I,J)
      DO 350 J=IDP1,K
      JMD = J - ID
  350 CXV2(MSP1,I,J) = Z(I,JMD)
  200 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SBCXY2(M,L,ID,MJ2)
      SUBROUTINE SBCXY2(CYY1,MJ3,M,L,ID,X2,CXY2)
C     THIS SUBROUTINE COMPUTES CXY2(LS) LS=0,M-1.
C     CXY2(LS)=CXY1(-LS)
C     =X2(0)*CYY1(-LS)+X2(1)*CYY1(-LS-1)+X2(2)*CYY1(-LS-2)+...
C     +X2(L)*CYY1(-LS-L).
      IMPLICIT REAL*8(A-H,O-Z)
cc      COMMON /COM3/X2
cc      COMMON /COM10/CYY1
cc      COMMON /COM110/CXY2
C
cc	DIMENSION X2(50,5,5),CYY1(160,5,5),CXY2(50,5,5)
cc	DIMENSION XX(5,5),CYY(5,5),Z(5,5),ZZ(5,5)
      DIMENSION X2(50,ID,ID),CYY1(MJ3,ID,ID),CXY2(50,ID,ID)
      DIMENSION XX(ID,ID),CYY(ID,ID),Z(ID,ID),ZZ(ID,ID)
C
      CST0=0.0D-00
      LP1=L+1
      DO 200 LSP1=1,M
      DO 209 I=1,ID
      DO 209 J=1,ID
  209 Z(I,J)=CST0
      DO 300 MSP1=1,LP1
      DO 310 I=1,ID
      DO 310 J=1,ID
  310 XX(I,J)=X2(MSP1,I,J)
      ML=LSP1+MSP1-1
      DO 320 I=1,ID
      DO 320 J=1,ID
  320 CYY(I,J)=CYY1(ML,J,I)
cc	CALL MULPLY(XX,CYY,ZZ,ID,ID,ID,MJ2,MJ2,MJ2)
cc	CALL MATADL(Z,ZZ,ID,ID,MJ2,MJ2)
      CALL MULPLY(XX,CYY,ZZ,ID,ID,ID)
      CALL MATADL(Z,ZZ,ID,ID)
  300 CONTINUE
      DO 350 I=1,ID
      DO 350 J=1,ID
  350 CXY2(LSP1,I,J)=Z(I,J)
  200 CONTINUE
      RETURN
      END
C
cc	SUBROUTINE SUBDAV(X,C0,G,R,N,K,ID,IAW,IPQ,MJ1,MJ2,ISWRO)
      SUBROUTINE SUBDAV(CYY1,MJ3,B,AW,IAW,NH,IDD,IR,IJ,IK,VD,X,C0,G,R,
cx     *  N,K,ID,IPQ,AICD,MJ1,MJ4,ISWRO,O,Q,X1,X2,CXY1,CXX1,CXV1,IFG,LU)
     *  N,K,ID,IPQ,AICD,MJ1,MJ4,ISWRO,O,Q,X1,X2,CXY1,CXX1,CXV1)
C     DAVIDON'S (MINIMIZATION) PROCEDURE
      IMPLICIT REAL*8(A-H,O-Z)
cc	COMMON /COM50/VD
      COMMON /COM101/AICO
cc	COMMON /COM199/AICD
cc	DIMENSION CYY1(160,5,5),B(10,5)
cc	DIMENSION IJ(5),IK(5)
cc	DIMENSION VD(50,50)
cc	DIMENSION X(100),C0(5,5),G(100),R(100),C0D(5,5)
cc     DIMENSION SX(100),SC0(5,5),SC0D(5,5),SG(100),SR(100)
cc	DIMENSION AW(50),IDD(10),IR(10)
      DIMENSION CYY1(MJ3,ID,ID),B(K,ID)
      DIMENSION IJ(ID),IK(ID)
      DIMENSION VD(MJ4,MJ4)
      DIMENSION X(MJ4),C0(ID,ID),G(MJ4),R(MJ4),C0D(ID,ID)
      DIMENSION SX(MJ4),SC0(ID,ID),SC0D(ID,ID),SG(MJ4),SR(MJ4)
cc      DIMENSION AW(IAW),IDD(K),IR(K)
      DIMENSION AW(IAW),NH(K),IDD(K),IR(K)
      DIMENSION O(50,ID,K),Q(50,K,ID),X1(50,K,K),X2(50,ID,ID)
      DIMENSION CXY1(100,ID,ID),CXX1(51,ID,ID),CXV1(51,ID,K)
C
C
C     DAVIDON'S PROCEDURE
C
C     CONSTANT
      CST1=1.0D-00
      CST0=0.0D-00
      CST2=2.0D-00
      CST01=0.1D-00
      CST05=0.5D-00
      CONSTA=0.5D-00
      CONSTB=2.0D-00
      EPS1=0.01D-00
      EPS3=0.000001D-00
      EPS4=0.1D-10
      EPS5=1.0D-15
      ITN=1
      ISPHAI=0
      IPHAI=1
      AIPQ=IPQ
      AN=N
      PHAID=CST1
C
cc  150 WRITE(6,160) ITN
cx  150 IF (IFG.NE.0) WRITE(LU,160) ITN
  160 FORMAT(//1H ,'ITN=',I5)
  150 CONTINUE
C
C     RO=G'*R COMPUTATION
      ITNS=0
   40 CALL INNERP(G,R,RO,IPQ)
cc	WRITE(6,2210) RO
cx      IF (IFG.NE.0) WRITE(LU,2210) RO
      IF(IPHAI.EQ.0) GO TO 101
C     DETERMINANT OF CXX(0) COMPUTATION
      DO 100 I=1,ID
      DO 100 J=1,ID
  100 C0D(I,J)=C0(I,J)
cc	CALL SUBDET(C0D,PHAI,ID,MJ2)
      CALL SUBDETM(C0D,PHAI,ID)
      PHAID=PHAI
  101 OPHAI=PHAI
      EPHAI1=EPS1*PHAI
      T1=RO-CST2*PHAI
      IF(T1.LE.EPHAI1) GO TO 140
C
      RAM=CST2*PHAI/RO
C
C     V=V+((RAM-1.0)/RO)*(R*R')
      RAMRO=(RAM-CST1)/RO
      DO 110 I=1,IPQ
      RAMROT=RAMRO*R(I)
      DO 110 J=1,IPQ
  110 VD(I,J)=VD(I,J)+RAMROT*R(J)
C
C     R=RAM*R
      DO 120 I=1,IPQ
  120 R(I)=RAM*R(I)
      IF(ITNS.GE.10) GO TO 140
      ITNS=ITNS+1
      GO TO 40
C
C     SX=X-R
cc  140 WRITE(6,600) ITNS,T1,EPHAI1
cx  140 IF (IFG.NE.0) WRITE(LU,600) ITNS,T1,EPHAI1
  600 FORMAT(1H ,'ITNS=',I5,5X,'RO-2.0*PHAI=',D12.5,5X,'EPHAI1=',D12.5)
  140 CONTINUE
      IG=0
  205 DO 210 I=1,IPQ
  210 SX(I)=X(I)-R(I)
C
C     SPHAI, SG COMPUTATION
cc	CALL C0GR(SX,SC0,SG,M,L,K,ID,IAW,IPQ,MJ1,MJ2,IG)
      CALL C0GR(CYY1,MJ3,B,AW,IAW,NH,IDD,IR,IJ,IK,SX,SC0,SG,M,L,K,ID,
cx     *        IPQ,MJ4,IG,O,Q,X1,X2,CXY1,CXX1,CXV1,IFG,LU)
     *        IPQ,MJ4,IG,O,Q,X1,X2,CXY1,CXX1,CXV1)
      IF(IG.EQ.0) GO TO 215
cc	WRITE(6,211)
cx      IF (IFG.NE.0) WRITE(LU,211)
  211 FORMAT(1H ,'HESSIAN MODIFIED FOR FEASIBILITY')
      DO 213 I=1,IPQ
      R(I)=CST05*R(I)
      DO 213 J=1,IPQ
  213 VD(I,J)=CST05*VD(I,J)
      GO TO 205
C
C     DETERMINANT OF (NEW CXX(0)) COMPUTATION
  215 DO 220 I=1,ID
      DO 220 J=1,ID
  220 SC0D(I,J)=SC0(I,J)
cc	CALL SUBDET(SC0D,SPHAI,ID,MJ2)
      CALL SUBDETM(SC0D,SPHAI,ID)
C
C
C     SR=V*SG
      DO 310 I=1,IPQ
      SUM=CST0
      DO 311 J=1,IPQ
  311 SUM=SUM+VD(I,J)*SG(J)
  310 SR(I)=SUM
C
C     SRO=(SG)'*(SR)
      CALL INNERP(SG,SR,SRO,IPQ)
      SROD=SRO/PHAI
cc	WRITE(6,340) SRO
cx      IF (IFG.NE.0) WRITE(LU,340) SRO
cc  340 FORMAT(1H ,'SRO=',D17.5)
  340 FORMAT(/1H ,'SRO=',D17.5)
C
C
C     DGAM=-G'*(SR)/SRO
      CALL INNERP(G,SR,GSR,IPQ)
      DGAM=-GSR/SRO
      DGAM1=DGAM+CST1
      DGAM1=DABS(DGAM1)+0.1D-70
      RAM=DABS(DGAM)/DGAM1
C     IF(RAM.LE.CONSTA) RAM=CONSTA
      IF(RAM.GT.CONSTA) GO TO 430
      RAM=CONSTA
      IRAM=1
cc	WRITE(6,420) RAM
cx      IF (IFG.NE.0) WRITE(LU,420) RAM
  420 FORMAT(1H ,'RAM=CONSTA=',D17.5)
      GO TO 470
C     IF(RAM.GE.CONSTB) RAM=CONSTB
  430 IF(RAM.LT.CONSTB) GO TO 450
      RAM=CONSTB
      IRAM=-1
cc	WRITE(6,440) RAM
cx      IF (IFG.NE.0) WRITE(LU,440) RAM
  440 FORMAT(1H ,'RAM=CONSTB=',D17.5)
      GO TO 470
C     RAM=RAM
  450 CONTINUE
      IRAM=0
cc	WRITE(6,460) RAM
cx      IF (IFG.NE.0) WRITE(LU,460) RAM
  460 FORMAT(1H ,'RAM=DGAM/(DGAM+1.0)=',D17.5)
C
C     V=V+((RAM-1.0)/SRO)*(SR)*(SR)'
  470 RAMSRO=(RAM-CST1)/SRO
      DO 480 I=1,IPQ
      RAMT=RAMSRO*SR(I)
      DO 480 J=1,IPQ
  480 VD(I,J)=VD(I,J)+RAMT*SR(J)
C
C
C
      IF(PHAI.GT.SPHAI) GO TO 540
C     SPHAI.GE.PHAI: TEST OF CORRECTION
      RAM1=RAM-CST1
      IF(DABS(RAM1).LT.EPS3) GO TO 555
      CONSDR=DGAM*RAM1
      DO 550 I=1,IPQ
  550 R(I)=R(I)-CONSDR*SR(I)
      IPHAI=0
      IF(SROD.GT.EPS4) GO TO 900
C     END OF ITERATION
  555 ISWRO=ISWRO+1
      GO TO 1000
C
C     SPHAI.LT.PHAI: SUCCESSFUL REDUCTION
  540 DO 560 I=1,IPQ
      X(I)=SX(I)
      G(I)=SG(I)
  560 R(I)=RAM*SR(I)
      DO 570 I=1,ID
      DO 570 J=1,ID
  570 C0(I,J)=SC0(I,J)
      PHAI=SPHAI
      IPHAI=1
  800 CONTINUE
      AICO=AN*DLOG(OPHAI)+CST2*AIPQ
      AICS=AN*DLOG(SPHAI)+CST2*AIPQ
      PHAID=SPHAI
      AICD=AICS
      DAIC=AICO-AICS
cc	WRITE(6,810) OPHAI,SPHAI,AICO,AICS,DAIC
cc  810 FORMAT(1H ,'OPHAI=',D17.5,5X,'SPHAI=',D17.5,5X,'OAIC=',D17.5,5X,'A
cc     AIC=',D17.5,5X,'DAIC=',D17.5)
cx      IF (IFG.NE.0) WRITE(LU,810) OPHAI,SPHAI,AICO,AICS,DAIC
  810 FORMAT(1H ,'OPHAI=',D17.5,5X,'SPHAI=',D17.5,/,' OAIC=',D17.5,5X,'A
     AIC=',D17.5,5X,'DAIC=',D17.5)
      IF(IRAM.NE.0) GO TO 901
      IF(SROD.LT.EPS4) GO TO 555
C     ITERATION CHECK
  900 IPQ2=IPQ+IPQ
      IF(ITN.GE.IPQ2) GO TO 555
      ISPHAI=(ISPHAI+(1-IPHAI))*(1-IPHAI)
      IF(ISPHAI.GE.5) GO TO 555
      ITN=ITN+1
      GO TO 150
  901 IF(DAIC.GE.CST01) GO TO 900
      IF(SROD.LT.EPS4) GO TO 555
      GO TO 900
C     END OF MINIMIZATION
  999 ISWRO=0
C
 1000 CONTINUE
      AICD=AN*DLOG(PHAID)+CST2*AIPQ
cc	WRITE(6,3609) AICD
cx      IF (IFG.NE.0) WRITE(LU,3609) AICD
 3609 FORMAT(/1H ,'AIC=N*LOG(DET(CXX0))+2.0*IPQ=',D12.5)
C     INNOVATION VARIANCE PRINT OUT
cc	WRITE(6,3610)
cc	DO 3620 I=1,ID
cc 3620 WRITE(6,3630) I,(C0(I,J),J=1,ID)
cx      IF (IFG.NE.0) THEN
cx	 WRITE(LU,3610)
cx	 DO 3620 I=1,ID
cx 3620	 WRITE(LU,3630) I,(C0(I,J),J=1,ID)
cx      END IF
      RETURN
 3610 FORMAT(/1H ,'INNOVATION VARIANCE')
 3630 FORMAT(/1H ,I5,10D12.5,/(1H ,5X,10D12.5))
 2210 FORMAT(1H ,'RO=',D12.5)
      END
C
cc	SUBROUTINE ARMACO(ID,K,MJ1,MJ2)
      SUBROUTINE ARMACO(A,B,AW,IAW,IH,IDD,IR,IJ,IK,ID,ICONT,K,BBM,
     *                  AAU,ZZ,IQM,MJ6,MJ7)
C     AR-MA COEFFICIENTS COMPUTATION
      IMPLICIT REAL*8 (A-H,O-Z)
cc	COMMON /COM60/ IDD,IR
cc	COMMON /COM61/ IJ,IK
cc	COMMON /COM70/ IH
cc	COMMON /COM80/ A
cc	COMMON /COM81/ B
cc	COMMON /COM82/ AW
cc	COMMON /COM87/ICONT
cc	DIMENSION A(10,10),B(10,5)
cc	DIMENSION AW(50)
cc	DIMENSION IH(10),IDD(10),IR(10),IJ(5),IK(5)
      DIMENSION A(K,K),B(K,ID)
      DIMENSION AW(IAW)
      DIMENSION IH(K),IDD(K),IR(K),IJ(ID),IK(ID)
      DIMENSION IO(K)
cc	DIMENSION BA(5,55),B0(5,5),BM(5,55),U(10,5),AU(10,5)
cc	DIMENSION W0(5,5),Z(5,5),ZZ(5,5)
      DIMENSION BA(ID,MJ6),B0(ID,ID),BM(ID,MJ6)
      DIMENSION U(K,ID),AU(K,ID,MJ7),AAU(ID,ID,MJ7)
      DIMENSION BBM(ID,ID,MJ6),W0(ID,ID),Z(ID,ID),ZZ(ID,ID,MJ7)
C     BA COMPUTATION
C     ORDER DETERMINATION
      CST0=0.0D-00
      CST1=1.0D-00
      IQMAX=0
      DO 100 I=1,K
      IQ=(IH(I)-1)/ID+1
      IO(I)=IQ
      IF(IO(I).LE.IQMAX)      GO TO 100
      IQMAX=IQ
100   CONTINUE
C
C     TRANSFORMATION OF AW(F MATRIX IN VECTOR FORM) INTO THE MATRICES OF
C     THE RAW AR-COEFFICIENTS.
C
cc	DO 150 I=1,5
cc	DO 150 J=1,55
      DO 150 I=1,ID
      DO 150 J=1,MJ6
  150 BA(I,J)=CST0
      ISUM=0
      IRS=0
      DO 201 I=1,K
      IF(IDD(I).EQ.0) GO TO 201
      IRS=IRS+1
      IKI=IK(IRS)
      JO=IH(I)-(IO(I)-1)*ID
      IDL=(IQMAX-IO(I))*ID
      IDL1=IDL+ID
      JA=IH(I)+IDL1
      BA(JO,JA)=-CST1
C
      DO 200 J=1,IKI
      ISUM=ISUM+1
      JB=IH(J)+IDL
      BA(JO,JB)=AW(ISUM)
200   CONTINUE
  201 CONTINUE
C     AR-COEFFICIENTS OUTPUT
cc	WRITE(6,7000)
cc 7000 FORMAT(//1H ,'AR-COEFFICIENTS B(MS) (MS=1,Q)')
      IQMAX=IQMAX+1
      IQM=IQMAX-1
      IQM1=IQM-1
cc	WRITE(6,7200) IQM
cc7200	FORMAT(/1H ,'K=',I5)
cc	WRITE(7,1000) ID,IQM,IQM1
      IQD=IQM*ID
      DO 300 I=1,ID
      DO 300 J=1,ID
      JDQ=IQD+J
  300 B0(I,J)=-BA(I,JDQ)
cc	MJ5=5
cc	MJ55=55
cc	CALL INVDET(B0,BDET,ID,MJ5)
cc	CALL MULPLY(B0,BA,BM,ID,ID,IQD,MJ5,MJ5,MJ55)
      CALL INVDET(B0,BDET,ID,ID)
      CALL MULPLY(B0,BA,BM,ID,ID,IQD)
cc	DO 321 I=1,5
cc	DO 321 J=1,55
      DO 321 I=1,ID
      DO 321 J=1,IQD
  321 BM(I,J)=-BM(I,J)
      DO 320 IRS=1,IQM
cc	WRITE(6,7250) IRS
      ISR=IQM-IRS
      ISRD=ISR*ID+1
      IRD=ISRD+ID-1
cc	DO 310 I=1,ID
cc	WRITE(6,1001) I,(BM(I,ISJ),ISJ=ISRD,IRD)
cc	WRITE(7,1002) (BM(I,ISJ),ISJ=ISRD,IRD)
cc  310 CONTINUE
      DO 310 I=1,ID
      DO 310 J=1,ID
	   BBM(I,J,IRS) = BM(I,ISRD+J-1)
  310 CONTINUE
320   CONTINUE
C     IMPULSE RESPONSE MATRICES OUTPUT
cc	WRITE(6,8000)
cc8000	FORMAT(/1H ,'IMPULSE RESPONSE MATRICES W(LS) (LS=1,Q-1)')
      DO 400 I=1,K
      DO 400 J=1,ID
400   U(I,J)=B(I,J)
      IQM1=IQM-1
      IMAJ=-ID
      DO 490 NS=1,IQM1
cc	WRITE(6,8100) NS
      IMAJ=IMAJ+ID
cc	CALL SUBAWZ(U,AU,K,ID,MJ1,MJ2)
      CALL SUBAWZ(AW,IAW,IDD,IR,U,AU(1,1,NS),K,ID)
      DO 470 I=1,ID
      IF(ICONT.EQ.0) GO TO 440
cc	WRITE(6,1001) I,(AU(I,J),J=1,ID)
cc  450 WRITE(7,1002) (AU(I,J),J=1,ID)
      DO 450 J=1,ID
	 AAU(I,J,NS)=AU(I,J,NS)
  450 CONTINUE
  440 DO 460 J=1,ID
      JMA=IMAJ+J
cc  460 BA(I,JMA)=AU(I,J)
  460 BA(I,JMA)=AU(I,J,NS)
  470 CONTINUE
      DO 480 I=1,K
      DO 480 J=1,ID
cc480	U(I,J)=AU(I,J)
480   U(I,J)=AU(I,J,NS)
490   CONTINUE
      IF(ICONT.EQ.1) GO TO 506
C     MA-COEFFICIENT COMPUTATION
cc	WRITE(6,8200)
cc 8200 FORMAT(/1H ,'MA-COEFFICIENTS A(LS) (LS=1,Q-1)')
      JW=-ID
      JB=IQD
      JB1=IQD
      DO 505 IT=1,IQM1
      JW=JW+ID
      JB=JB-ID
      DO 500 I=1,ID
      DO 500 J=1,ID
      JWJ=JW+J
      JBJ=JB+J
cc  500 ZZ(I,J)=BA(I,JWJ)+BM(I,JBJ)
  500 ZZ(I,J,IT)=BA(I,JWJ)+BM(I,JBJ)
      IF(IT.EQ.1) GO TO 503
      ITM1=IT-1
      JTW=JW
      JTB=JB1
      DO 502 JT=1,ITM1
      JTW=JTW-ID
      JTB=JTB-ID
      DO 501 I=1,ID
      DO 501 J=1,ID
      JTBJ=JTB+J
      JTWJ=JTW+J
      B0(I,J)=BM(I,JTBJ)
  501 W0(I,J)=BA(I,JTWJ)
cc	CALL MULPLY(B0,W0,Z,ID,ID,ID,MJ2,MJ2,MJ2)
cc	CALL MATADL(ZZ,Z,ID,ID,MJ2,MJ2)
      CALL MULPLY(B0,W0,Z,ID,ID,ID)
      CALL MATADL(ZZ(1,1,IT),Z,ID,ID)
  502 CONTINUE
cc  503 WRITE(6,8300) IT
  503 CONTINUE
cc	DO 504 I=1,ID
cc	WRITE(6,1001) I,(ZZ(I,J),J=1,ID)
cc	WRITE(7,1002) (ZZ(I,J),J=1,ID)
cc  504 CONTINUE
  505 CONTINUE
  506 CONTINUE
      RETURN
1000  FORMAT(16I5)
 1001 FORMAT(1H ,I5,4X,10D12.5)
1002  FORMAT(4D20.10)
1003  FORMAT(6I5)
7250  FORMAT(/1H ,'B(MS) MS=',I5)
2003  FORMAT(/1H ,'BA')
8100  FORMAT(/1H ,'W(LS) LS=',I5)
 8300 FORMAT(/1H ,'A(LS) LS=',I5)
      END
C
cc	SUBROUTINE  RESCAL ( K,ID )
cx      SUBROUTINE  RESCAL ( B,AW,IAW,NH,IDD,IR,IJ,IDUMMY,K,ID,IFG,LU )
      SUBROUTINE  RESCAL ( B,AW,IAW,NH,IDD,IR,IJ,IDUMMY,K,ID )
C     RESCALING OF F AND G MATRICES FOR A FEASIBLE INITIAL
      IMPLICIT REAL*8(A-H,O-Z)
cc	COMMON /COM60/IDD , IR
cc	COMMON /COM61/IJ, IDUMMY
cc	COMMON /COM70/NH
cc	COMMON /COM82/AW
cc	COMMON /COM81/B
cc	DIMENSION AW(50),B(10,5)
cc	DIMENSION IJ(5),NH(10),IR(10)
cc	DIMENSION IDUMMY(5)
cc	DIMENSION IDD(10)
cc	DIMENSION IO(10)
      DIMENSION AW(IAW),B(K,ID)
      DIMENSION IJ(ID),NH(K),IR(K)
cc      DIMENSION IDUMMY(ID)
      DIMENSION IDD(K)
      DIMENSION IO(K)
C
      RO9=0.95D-00
      DO 10 I=1,K
   10 IO(I)=(NH(I)-1)/ID
C
C     F MATRIX RESCALING
      IKSJ = 0
      DO 20 I=1,K
      IF(IDD(I).EQ.0) GO TO 20
      IM = IO(I) + 1
      KS=KS+1
      JL = IR(I)
      DO 30 J=1,JL
      IOR = IM - IO(J)
      SCALE=RO9**IOR
      IKSJ = IKSJ + 1
   30 AW(IKSJ)=AW(IKSJ)*SCALE
   20 CONTINUE
C
C     G MATRIX RESCALING
      IDP1=ID+1
      DO 40 I=IDP1,K
      IOI=IO(I)
      SCALE=RO9**IOI
      DO 50 J=1,ID
   50 B(I,J) = B(I,J) * SCALE
   40 CONTINUE
cc	WRITE(6,2000)
cx      IF (IFG.NE.0) WRITE(LU,2000)
 2000 FORMAT(/1H ,'INITIAL MODIFIED FOR FEASIBILITY')
      RETURN
      END
C
cc	SUBROUTINE SUBDET(X,XDETMI,MM,MJ)
      SUBROUTINE SUBDETM(X,XDETMI,MM)
C *** COMMON SUBROUTINE
C     THIS SUBROUTINE COMPUTES THE DETERMINANT OF UPPER LEFT MM X MM
C     OF X.  FOR GENERAL USE STATEMENTS 20-21 SHOULD BE RESTORED.
C     X: ORIGINAL MATRIX
C     XDETMI: DETERMINANT OF UPPER LEFT MM X MM OF X
C     MJ: ABSOLUTE DIMENSION OF X IN THE MAIN ROUTINE
      IMPLICIT REAL*8(X)
cc	DIMENSION X(MJ,MJ)
      DIMENSION X(MM,MM)
      CST0=0.0D-00
      CST1=1.0D-00
      XDETMI=CST1
      IF(MM.EQ.1) GO TO 18
      MM1=MM-1
      DO 10 I=1,MM1
   20 IF(X(I,I).NE.CST0) GO TO 11
      DO 12 J=I,MM
      IF(X(I,J).EQ.CST0) GO TO 12
      JJ=J
      GO TO 13
   12 CONTINUE
      XDETMI=CST0
      GO TO 17
   13 DO 14 K=I,MM
      XXC=X(K,JJ)
      X(K,JJ)=X(K,I)
   14 X(K,I)=XXC
   21 XDETMI=-XDETMI
   11 XDETMI=XDETMI*X(I,I)
      XC=CST1/X(I,I)
      I1=I+1
      DO 15 J=I1,MM
      XXC=X(J,I)*XC
      DO 16 K=I1,MM
   16 X(J,K)=X(J,K)-X(I,K)*XXC
   15 CONTINUE
   10 CONTINUE
   18 XDETMI=XDETMI*X(MM,MM)
   17 RETURN
      END
C
