% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_tcga_group_trans_exp.R
\name{trans_exp_new}
\alias{trans_exp_new}
\title{trans_exp_new}
\usage{
trans_exp_new(exp, mrna_only = FALSE, lncrna_only = FALSE, species = "human")
}
\arguments{
\item{exp}{expression set with ensembl as rownames}

\item{mrna_only}{only keep mrna rows in result}

\item{lncrna_only}{only keep lncrna rows in result}

\item{species}{choose human or mouse, or rat, default: human}
}
\value{
a transformed expression set with symbol
}
\description{
transform rownames of expression set from "ensembl" to"symbol",according to the new information from ensembl database.
}
\examples{
exp = matrix(rnorm(1000),ncol = 10)
rownames(exp) = sample(mRNA_annov23$gene_id,100)
colnames(exp) = c(paste0("TCGA",1:5),paste0("GTEX",1:5))
k  = trans_exp_new(exp)
}
\seealso{
\code{\link{trans_exp}}
}
\author{
Xiaojie Sun
}
