% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_get_deg.R
\name{get_deg}
\alias{get_deg}
\title{get_deg}
\usage{
get_deg(
  exp,
  group_list,
  ids,
  logFC_cutoff = 1,
  pvalue_cutoff = 0.05,
  adjust = FALSE,
  entriz = TRUE,
  species = "human"
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{ids}{a data.frame with 2 columns,including probe_id and symbol}

\item{logFC_cutoff}{Cutoff value of logFC,1 by default.}

\item{pvalue_cutoff}{Cutoff value of pvalue,0.05 by default.}

\item{adjust}{a logical value, would you like to use adjusted pvalue to draw this plot,FAlSE by default.}

\item{entriz}{whether convert symbols to entriz ids}

\item{species}{choose human or mouse, or rat, default: human}
}
\value{
a deg data.frame with 10 columns
}
\description{
do differential analysis according to expression set and group information
}
\examples{
\dontrun{
if(requireNamespace("Biobase",quietly = TRUE)&
   requireNamespace("AnnoProbe",quietly = TRUE)){
  gse = "GSE42872"
  a = geo_download(gse,destdir=tempdir())
  find_anno(geo$gpl)
  ids <- AnnoProbe::idmap(geo$gpl,destdir = tempdir())
  Group = rep(c("control","treat"),each = 3)
  Group = factor(Group)
  deg = get_deg(geo$exp,Group,ids,entriz = FALSE)
  head(deg)
}else{
  if(!requireNamespace("AnnoProbe",quietly = TRUE)) {
    warning("Package 'AnnoProbe' needed for this function to work.
         Please install it by install.packages('AnnoProbe')",call. = FALSE)
  }
  if(!requireNamespace("Biobase",quietly = TRUE)) {
    warning("Package 'Biobase' needed for this function to work.
         Please install it by BiocManager::install('Biobase')",call. = FALSE)
  }
}
}
}
\seealso{
\code{\link{multi_deg}};\code{\link{get_deg_all}}
}
\author{
Xiaojie Sun
}
