% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lock.R
\name{lock}
\alias{lock}
\alias{lock_TF}
\alias{\%<-c\%}
\title{Lock T, Lock F, or Create Locked Constants}
\usage{
lock_TF(env)

X \%<-c\% A
}
\arguments{
\item{env}{an optional environment to give,
determining in which environment \code{T} and \code{F} should be locked. \cr
When not specified, the current environment
(like the global environment, or the environment within a function)
is used. \cr}

\item{X}{a syntactically valid unquoted name of the object to be created.}

\item{A}{any kind of object to be assigned to \code{X}.}
}
\value{
For \code{lock_TF()}: \cr
Two \code{constants}, namely \code{T} and \code{F},
set to \code{TRUE} and \code{FALSE} respectively,
are created in the specified or else current environment,
and locked.
Removing the created \code{T} and \code{F} objects allows re-assignment again. \cr
\cr
For \code{X \%<-c\% A}: \cr
The object \code{X} containing \code{A} is created in the current environment,
and this object cannot be changed. It can only be accessed or removed.
}
\description{
One can re-assign the values \code{T} and \code{F}.
One can even run things like \code{T <- FALSE} and \code{F <- TRUE} ! \cr
The \code{lock_TF()} function
locks the \code{T} and \code{F} values and sets them to \code{TRUE} and \code{FALSE},
respectively,
to prevent the user from re-assigning them. \cr
Removing the created \code{T} and \code{F} objects
allows re-assignment again. \cr
\cr
The \code{X \%<-c\% A} operator creates a \code{constant} \code{X}
and assigns \code{A} to it. \cr
Constants cannot be changed, only accessed or removed.
So if you have a piece of code that requires some unchangeable \code{constant},
use this operator to create said \code{constant}. \cr
Removing constant \code{X} also removes its binding lock.
Thus to change a \code{constant}, simply remove it and re-create it. \cr
}
\details{
Note that following statement

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x \%<-c\% 2+2
print(x)
}\if{html}{\out{</div>}}

returns

\if{html}{\out{<div class="sourceCode r">}}\preformatted{[1] 2
}\if{html}{\out{</div>}}

due to R's precedence rules.
Therefore, in such cases, the right hand side of
\code{X \%<-c\% A} need to be surrounded with brackets.
I.e.:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x \%<-c\% (2+2)
}\if{html}{\out{</div>}}
}
\examples{

lock_TF()
X \%<-c\% data.frame(x=3, y=2) # this data.frame cannot be changed. Only accessed or removed.
X[1, ,drop=FALSE]


}
\seealso{
\code{\link[=tinycodet_safer]{tinycodet_safer()}}
}
