% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stri_join_mat.R
\name{stri_join_mat}
\alias{stri_join_mat}
\alias{stri_c_mat}
\alias{stri_paste_mat}
\title{Concatenate Character Matrix Row-wise or Column-wise}
\usage{
stri_join_mat(mat, margin = 1, sep = "", collapse = NULL)

stri_c_mat(mat, margin = 1, sep = "", collapse = NULL)

stri_paste_mat(mat, margin = 1, sep = "", collapse = NULL)
}
\arguments{
\item{mat}{a matrix of strings}

\item{margin}{the margin over which the strings must be joined.
\itemize{
\item If \code{margin = 1}, the elements within each row of matrix \code{mat}
are joined into a single string.
Thus if the matrix has 10 rows, it returns a vector of 10 strings.
\item If \code{margin = 2}, the elements within each column of matrix \code{mat}
are joined into a single string.
Thus if the matrix has 10 columns, it returns a vector of 10 strings. \cr
}}

\item{sep, collapse}{as in \link[stringi]{stri_join}.}
}
\value{
The \code{stri_join_mat()} function, and its aliases, return a vector of strings.
}
\description{
The \code{stri_join_mat()} function
(and their aliases \code{stri_c_mat} and \code{stri_paste_mat})
perform row-wise (\code{margin = 1}; the default) or
column-wise (\code{margin = 2}) joining of a matrix of strings,
thereby transforming a matrix of strings into a vector of strings.
}
\examples{

#############################################################################

# Basic example

x <- matrix(letters[1:25], ncol = 5, byrow = TRUE)
print(x)
stri_join_mat(x, margin = 1)

x <- matrix(letters[1:25], ncol = 5, byrow = FALSE)
print(x)
stri_join_mat(x, margin = 2)


#############################################################################
# sorting characters in strings ====

x <- c(paste(sample(letters), collapse = ""),
       paste(sample(letters), collapse = ""))
print(x)
mat <- strcut_brk(x)
rank <- stringi::stri_rank(as.vector(mat)) |>  matrix(ncol=ncol(mat))
sorted <- mat \%row~\% rank
sorted[is.na(sorted)] <- ""
print(sorted)
stri_join_mat(sorted, margin = 1)
stri_join_mat(sorted, margin = 2)


#############################################################################

# sorting words ====

x <- c("2nd 3rd 1st", "Goodbye everyone")
print(x)
mat <- strcut_brk(x, "word")
rank <- stringi::stri_rank(as.vector(mat)) |> matrix(ncol=ncol(mat))
sorted <- mat \%row~\% rank
sorted[is.na(sorted)] <- ""
stri_c_mat(sorted, margin = 1, sep = " ") # <- alias for stri_join_mat
stri_c_mat(sorted, margin = 2, sep = " ")


#############################################################################

# randomly shuffling sentences ====

x <- c("Hello, who are you? Oh, really?! Cool!",
       "I don't care. But I really don't.")
print(x)
mat <- strcut_brk(x, "sentence")
rank <- sample(1:length(mat)) |> matrix(ncol = ncol(mat))
sorted <- mat \%row~\% rank
sorted[is.na(sorted)] <- ""
stri_paste_mat(sorted, margin = 1) # <- another alias for stri_join_mat
stri_paste_mat(sorted, margin = 2)

}
\seealso{
\link{tinycodet_strings}
}
\concept{join_mat}
