% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_label.R
\name{variable_label}
\alias{variable_label}
\alias{variable_label.default}
\alias{variable_label.data.frame}
\alias{variable_label<-}
\alias{variable_label<-.default}
\alias{variable_label<-.data.frame}
\alias{variable_labels}
\alias{variable_labels<-}
\title{Assign or Extract Variable Labels}
\usage{
variable_label(x, ...)

\method{variable_label}{default}(x, ...)

\method{variable_label}{data.frame}(x, ...)

variable_label(x) <- value

\method{variable_label}{default}(x) <- value

\method{variable_label}{data.frame}(x) <- value

variable_labels(x, ...)

variable_labels(x) <- value
}
\arguments{
\item{x}{Either a vector or a \code{data.frame}.}

\item{...}{Further arguments that may be passed to methods.}

\item{value}{Character. The variable label(s) to be assigned. If \code{variable_label()} is applied to a single vector,
this should be a length-one argument. If applied to a \code{data.frame}, \code{value} is required to be a \emph{named} vector
or a \emph{named} list.
Check the examples for details.}
}
\value{
For vectors, \code{variable_label} returns NULL or the variable label (typically of length one).
For data frames, \code{variable_label} returns a named list where each column corresponds to a column of the data frame.

The assignment methods \verb{variable_label<-} return the labelled object.
}
\description{
Assign or extract variable labels of a \code{vector} \emph{or}
the columns (i.e., vectors) of a \code{data.frame}.
}
\examples{
  # label a single vector
  variable_label(letters) <- "The alphabet" # Assign
  variable_label(letters)                   # Extract

  # label some columns of a data frame
  variable_labels(npk) <- list(             # Assign
    N = "Nitrogen"
    , P = "Phosphate"
    , K = expression(italic(K))
  )
  variable_labels(npk)                      # Extract
}
\seealso{
See \code{\link[=label_variable]{label_variable()}} for an alternative that is compatible with the tidyverse's pipe operator.
}
