% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinyplot.R
\name{tinyplot}
\alias{tinyplot}
\alias{tinyplot.default}
\alias{tinyplot.formula}
\alias{tinyplot.density}
\alias{plt}
\title{Lightweight extension of the base R plotting function}
\usage{
tinyplot(x, ...)

\method{tinyplot}{default}(
  x,
  y = NULL,
  by = NULL,
  facet = NULL,
  facet.args = NULL,
  data = NULL,
  type = "p",
  xlim = NULL,
  ylim = NULL,
  log = "",
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  ann = par("ann"),
  axes = TRUE,
  frame.plot = axes,
  asp = NA,
  grid = NULL,
  palette = NULL,
  legend = NULL,
  pch = NULL,
  lty = NULL,
  lwd = NULL,
  col = NULL,
  bg = NULL,
  fill = NULL,
  alpha = NULL,
  cex = 1,
  restore.par = FALSE,
  ymin = NULL,
  ymax = NULL,
  ribbon.alpha = NULL,
  add = FALSE,
  file = NULL,
  width = NULL,
  height = NULL,
  ...
)

\method{tinyplot}{formula}(
  x = NULL,
  data = parent.frame(),
  facet = NULL,
  facet.args = NULL,
  type = "p",
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  ann = par("ann"),
  axes = TRUE,
  frame.plot = axes,
  asp = NA,
  grid = NULL,
  pch = NULL,
  col = NULL,
  lty = NULL,
  lwd = NULL,
  restore.par = FALSE,
  formula = NULL,
  subset = NULL,
  na.action = NULL,
  drop.unused.levels = TRUE,
  ...
)

\method{tinyplot}{density}(
  x = NULL,
  by = NULL,
  facet = NULL,
  facet.args = NULL,
  type = c("l", "area"),
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  ann = par("ann"),
  axes = TRUE,
  frame.plot = axes,
  asp = NA,
  grid = NULL,
  pch = NULL,
  col = NULL,
  lty = NULL,
  lwd = NULL,
  bg = NULL,
  fill = NULL,
  restore.par = FALSE,
  ...
)

plt(x, ...)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the
plot. Any reasonable way of defining the coordinates is acceptable; most
likely the names of existing vectors or columns of data frames. See the
'Examples' section below, or the function
\code{\link[grDevices]{xy.coords}} for details. If supplied separately, \code{x}
and \code{y} must be of the same length.}

\item{...}{other graphical parameters. See \code{\link[graphics]{par}} or
the "Details" section of \code{\link[graphics]{plot}}.}

\item{by}{grouping variable(s). The default behaviour is for groups to be
represented in the form of distinct colours, which will also trigger an
automatic legend. (See \code{legend} below for customization options.) However,
groups can also be presented through other plot parameters (e.g., \code{pch} or
\code{lty}) by passing an appropriate "by" keyword; see Examples. Note that
continuous (i.e., gradient) colour legends are also supported if the user
passes a numeric or integer to \code{by}.}

\item{facet}{the faceting variable(s) that you want arrange separate plot
windows by. Can be specified in various ways:
\itemize{
\item In "atomic" form, e.g. \code{facet = fvar}. To facet by multiple variables in
atomic form, simply interact them, e.g.
\code{interaction(fvar1, fvar2)} or \code{factor(fvar1):factor(fvar2)}.
\item As a one-sided formula, e.g. \code{facet = ~fvar}. Multiple variables can be
specified in the formula RHS, e.g. \code{~fvar1 + fvar2} or \code{~fvar1:fvar2}. Note
that these multi-variable cases are \emph{all} treated equivalently and
converted to \code{interaction(fvar1, fvar2, ...)} internally. (No distinction
is made between different types of binary operators, for example, and so
\code{f1+f2} is treated the same as \code{f1:f2}, is treated the same as \code{f1*f2},
etc.)
\item As a two-side formula, e.g. \code{facet = fvar1 ~ fvar2}. In this case, the
facet windows are arranged in a fixed grid layout, with the formula LHS
defining the facet rows and the RHS defining the facet columns. At present
only single variables on each side of the formula are well supported. (We
don't recommend trying to use multiple variables on either the LHS or RHS
of the two-sided formula case.)
\item As a special \code{"by"} convenience keyword, in which case facets will match
the grouping variable(s) passed to \code{by} above.
}}

\item{facet.args}{an optional list of arguments for controlling faceting
behaviour. (Ignored if \code{facet} is NULL.) Supported arguments are as
follows:
\itemize{
\item \code{nrow}, \code{ncol} for overriding the default "square" facet window
arrangement. Only one of these should be specified, but \code{nrow} will take
precedence if both are specified together. Ignored if a two-sided formula
is passed to the main \code{facet} argument, since the layout is arranged in a
fixed grid.
\item \code{fmar} a vector of form \code{c(b,l,t,r)} for controlling the base margin
between facets in terms of lines. Defaults to the value of \code{tpar("fmar")},
which should be \code{c(1,1,1,1)}, i.e. a single line of padding around each
individual facet, assuming it hasn't been overridden by the user as part
their global \code{\link[tinyplot]{tpar}} settings. Note some automatic
adjustments are made for certain layouts, and depending on whether the plot
is framed or not, to reduce excess whitespace. See
\code{\link[tinyplot]{tpar}} for more details.
\item \code{cex}, \code{font}, \code{col}, \code{bg}, \code{border} for adjusting the facet title text
and background. Default values for these arguments are inherited from
\code{\link[tinyplot]{tpar}} (where they take a "facet." prefix, e.g.
\code{tpar("facet.cex")}). The latter function can also be used to set these
features globally for all \code{tinyplot} plots.
}}

\item{data}{a data.frame (or list) from which the variables in formula
should be taken. A matrix is converted to a data frame.}

\item{type}{character string giving the type of plot desired. Options are:
\itemize{
\item The same set of 1-character values supported by plot: "p" for points, "l"
for lines, "b" for both points and lines, "c" for empty points joined by
lines, "o" for overplotted points and lines, "s" and "S" for stair steps
and "h" for histogram-like vertical lines. "n" does not produce
any points or lines.
\item Additional tinyplot types: "density" for densities, "polygon" for
polygons,  "pointrange" or "errorbar" for segment intervals, and "polygon",
"ribbon" or "area" for polygon intervals (where area plots are a special
case of ribbon plots with \code{ymin} set to 0 and \code{ymax} set to \code{y}; see below).
}}

\item{xlim}{the x limits (x1, x2) of the plot. Note that x1 > x2 is allowed
and leads to a ‘reversed axis’. The default value, NULL, indicates that
the range of the \code{finite} values to be plotted should be used.}

\item{ylim}{the y limits of the plot.}

\item{log}{a character string which contains "x" if the x axis is to be
logarithmic, "y" if the y axis is to be logarithmic and "xy" or "yx" if
both axes are to be logarithmic.}

\item{main}{a main title for the plot, see also \code{title}.}

\item{sub}{a subtitle for the plot.}

\item{xlab}{a label for the x axis, defaults to a description of x.}

\item{ylab}{a label for the y axis, defaults to a description of y.}

\item{ann}{a logical value indicating whether the default annotation (title
and x and y axis labels) should appear on the plot.}

\item{axes}{a logical value indicating whether both axes should be drawn on
the plot. Use \verb{graphical parameter} "xaxt" or "yaxt" to suppress just one of
the axes.}

\item{frame.plot}{a logical indicating whether a box should be drawn around
the plot. Can also use \code{frame} as an acceptable argument alias.}

\item{asp}{the y/xy/x aspect ratio, see \code{plot.window}.}

\item{grid}{argument for plotting a background panel grid, one of either:
\itemize{
\item a logical (i.e., \code{TRUE} to draw the grid), or
\item a panel grid plotting function like \code{grid()}.
Note that this argument replaces the \code{panel.first} and \code{panel.last}
arguments from base \code{plot()} and tries to make the process more seamless
with better default behaviour. The default behaviour is determined by (and
can be set globally through) the value of \code{tpar("grid")}.
}}

\item{palette}{one of the following options:
\itemize{
\item NULL (default), in which case the palette will be chosen according to
the class and cardinality of the "by" grouping variable. For non-ordered
factors or strings with a reasonable number of groups, this will inherit
directly from the user's default \code{\link[grDevices]{palette}} (e.g.,
"R4"). In other cases, including ordered factors and high cardinality, the
"Viridis" palette will be used instead. Note that a slightly restricted
version of the "Viridis" palette---where extreme color values have been
trimmed to improve visual perception---will be used for ordered factors
and continuous variables. In the latter case of a continuous grouping
variable, we also generate a gradient legend swatch.
\item A convenience string corresponding to one of the many palettes listed by
either \code{palette.pals()} or \code{hcl.pals()}. Note that the string can be
case-insensitive (e.g., "Okabe-Ito" and "okabe-ito" are both valid).
\item A palette-generating function. This can be "bare" (e.g.,
\code{palette.colors}) or "closed" with a set of named arguments (e.g.,
\code{palette.colors(palette = "Okabe-Ito", alpha = 0.5)}). Note that any
unnamed arguments will be ignored and the key \code{n} argument, denoting the
number of colours, will automatically be spliced in as the number of
groups.
}}

\item{legend}{one of the following options:
\itemize{
\item NULL (default), in which case the legend will be determined by the
grouping variable. If there is no group variable (i.e., \code{by} is NULL) then
no legend is drawn. If a grouping variable is detected, then an automatic
legend is drawn to the \emph{outer} right of the plotting area. Note that the
legend title and categories will automatically be inferred from the \code{by}
argument and underlying data.
\item A convenience string indicating the legend position. The string should
correspond to one of the position keywords supported by the base \code{legend}
function, e.g. "right", "topleft", "bottom", etc. In addition, \code{tinyplot}
supports adding a trailing exclamation point to these keywords, e.g.
"right!", "topleft!", or "bottom!". This will place the legend \emph{outside}
the plotting area and adjust the margins of the plot accordingly. Finally,
users can also turn off any legend printing by specifying "none".
\item Logical value, where TRUE corresponds to the default case above (same
effect as specifying NULL) and FALSE turns the legend off (same effect as
specifying "none").
\item A list or, equivalently, a dedicated \code{legend()} function with supported
legend arguments, e.g. "bty", "horiz", and so forth.
}}

\item{pch}{plotting "character", i.e., symbol to use. Character, integer, or
vector of length equal to the number of categories in the \code{by} variable.
See \code{pch}. In addition, users can supply a special \code{pch = "by"} convenience
argument, in which case the characters will automatically loop over the
number groups. This automatic looping will begin at the global character
value (i.e., \code{par("pch")}) and recycle as necessary.}

\item{lty}{line type. Character, integer, or vector of length equal to the
number of categories in the \code{by} variable. See \code{lty}. In addition, users
can supply a special \code{lty = "by"} convenience argument, in which case the
line type will automatically loop over the number groups. This automatic
looping will begin at the global line type value (i.e., \code{par("lty")}) and
recycle as necessary.}

\item{lwd}{line width. Numeric scalar or vector of length equal to the
number of categories in the \code{by} variable. See \code{lwd}. In addition, users
can supply a special \code{lwd = "by"} convenience argument, in which case the
line width will automatically loop over the number of groups. This
automatic looping will be centered at the global line width value (i.e.,}

\item{col}{plotting color. Character, integer, or vector of length equal to
the number of categories in the \code{by} variable. See \code{col}. Note that the
default behaviour in \code{tinyplot} is to vary group colors along any variables
declared in the \code{by} argument. Thus, specifying colors manually should not
be necessary unless users wish to override the automatic colors produced by
this grouping process. Typically, this would only be done if grouping
features are deferred to some other graphical parameter (i.e., passing the
"by" keyword to one of \code{pch}, \code{lty}, \code{lwd}, or \code{bg}; see below.)}

\item{bg}{background fill color for the open plot symbols 21:25 (see
\code{points.default}), as well as ribbon and area plot types. For the latter
group---including filled density plots---an automatic alpha transparency
adjustment will be applied (see the \code{ribbon.alpha} argument further below).
Users can also supply either one of two special convenience arguments that
will cause the background fill to inherit the automatic grouped coloring
behaviour of \code{col}:
\itemize{
\item \code{bg = "by"} will insert a background fill that inherits the main color
mappings from \code{col}.
\item \verb{by = <numeric[0,1]>} (i.e., a numeric in the range \verb{[0,1]}) will insert
a background fill that inherits the main color mapping(s) from \code{col}, but
with added alpha-transparency.
}

For both of these convenience arguments, note that the (grouped) \code{bg}
mappings will persist even if the (grouped) \code{col} defaults are themselves
overridden. This can be useful if you want to preserve the grouped palette
mappings by background fill but not boundary color, e.g. filled points. See
examples.}

\item{fill}{alias for \code{bg}. If non-NULL values for both \code{bg} and \code{fill} are
provided, then the latter will be ignored in favour of the former.}

\item{alpha}{a numeric in the range \verb{[0,1]} for adjusting the alpha channel
of the color palette, where 0 means transparent and 1 means opaque. Use
fractional values, e.g. \code{0.5} for semi-transparency.}

\item{cex}{character expansion. A numerical vector (can be a single value)
giving the amount by which plotting characters and symbols should be scaled
relative to the default. Note that NULL is equivalent to 1.0, while NA
renders the characters invisible.}

\item{restore.par}{a logical value indicating whether the
\code{\link[graphics]{par}} settings prior to calling \code{tinyplot} should be
restored on exit. Defaults to FALSE, which makes it possible to add
elements to the plot after it has been drawn. However, note the the outer
margins of the graphics device may have been altered to make space for the
\code{tinyplot} legend. Users can opt out of this persistent behaviour by
setting to TRUE instead. See also \link{get_saved_par} for another option to
recover the original \code{\link[graphics]{par}} settings, as well as
longer discussion about the trade-offs involved.}

\item{ymin, ymax}{minimum and maximum coordinates of interval plot types. Only
used when the \code{type} argument is one of "pointrange", "errorbar", or
"ribbon".}

\item{ribbon.alpha}{numeric factor modifying the opacity alpha of any ribbon
shading; typically in \verb{[0, 1]}. Only used when \code{type = "ribbon"}, or when
the \code{bg} fill argument is specified in a density plot (since filled density
plots are converted to ribbon plots internally). If an an applicable plot
type is called but no explicit value is provided, then will default to
\code{tpar("ribbon.alpha")} (i.e., probably \code{0.2} unless this has been
overridden by the user in their global settings.)}

\item{add}{logical. If TRUE, then elements are added to the current plot rather
than drawing a new plot window. Note that the automatic legend for the
added elements will be turned off.}

\item{file}{character string giving the file path for writing a plot to disk.
If specified, the plot will not be displayed interactively, but rather sent
to the appropriate external graphics device (i.e.,
\code{\link[grDevices]{png}}, \code{\link[grDevices]{jpeg}},
\code{\link[grDevices]{pdf}}, or \code{\link[grDevices]{svg}}). As a point
of convenience, note that any global parameters held in \verb{(t)par} are
automatically carried over to the external device and don't need to be
reset (in contrast to the conventional base R approach that requires
manually opening and closing the device). The device type is determined by
the file extension at the end of the provided path, and must be one of
".png", ".jpg" (".jpeg"), ".pdf", or ".svg". (Other file types may be
supported in the future.) The file dimensions can be controlled by the
corresponding \code{width} and \code{height} arguments below, otherwise will fall
back to the \code{"file.width"} and \code{"file.height"} values held in
\code{\link[tinyplot]{tpar}} (i.e., both defaulting to 7 inches, and where
the default resolution for bitmap files is also specified as 300
DPI).}

\item{width}{numeric giving the plot width in inches. Together with \code{height},
typically used in conjunction with the \code{file} argument above, overriding the
default values held in \code{tpar("file.width", "file.height")}. If either \code{width}
or \code{height} is specified, but a corresponding \code{file} argument is not
provided as well, then a new interactive graphics device dimensions will be
opened along the given dimensions. Note that this interactive resizing may
not work consistently from within an IDE like RStudio that has an integrated
graphics windows.}

\item{height}{numeric giving the plot height in inches. Same considerations as
\code{width} (above) apply, e.g. will default to \code{tpar("file.height")} if not
specified.}

\item{formula}{a \code{formula} that optionally includes grouping variable(s)
after a vertical bar, e.g. \code{y ~ x | z}. One-sided formulae are also
permitted, e.g. \code{~ y | z}. Note that the \code{formula} and \code{x} arguments
should not be specified in the same call.}

\item{subset, na.action, drop.unused.levels}{arguments passed to \code{model.frame}
when extracting the data from \code{formula} and \code{data}.}
}
\value{
No return value, called for side effect of producing a plot.
}
\description{
Enhances the base \code{\link[graphics]{plot}} function. Supported features
include automatic legends and facets for grouped data, additional plot types,
theme customization, and so on. Users can call either \code{tinyplot()}, or its
shorthand alias \code{plt()}.
}
\details{
Disregarding the enhancements that it supports, \code{tinyplot} tries as far as
possible to mimic the behaviour and syntax logic of the original base
\code{\link[graphics]{plot}} function. Users should therefore be able to swap
out existing \code{plot} calls for \code{tinyplot} (or its shorthand alias \code{plt}),
without causing unexpected changes to the output.
}
\examples{
#' 
aq = transform(
  airquality,
  Month = factor(Month, labels = month.abb[unique(Month)])
)

# In most cases, `tinyplot` should be a drop-in replacement for regular
# `plot` calls. For example:

op = tpar(mfrow = c(1, 2))
plot(0:10, main = "plot")
tinyplot(0:10, main = "tinyplot")
tpar(op) # restore original layout

# Aside: `tinyplot::tpar()` is a (near) drop-in replacement for `par()`

# Unlike vanilla plot, however, tinyplot allows you to characterize groups 
# using either the `by` argument or equivalent `|` formula syntax.

with(aq, tinyplot(Day, Temp, by = Month)) ## atomic method
tinyplot(Temp ~ Day | Month, data = aq)   ## formula method

# (Notice that we also get an automatic legend.)

# You can also use the equivalent shorthand `plt()` alias if you'd like to
# save on a few keystrokes

plt(Temp ~ Day | Month, data = aq) ## shorthand alias

# Use standard base plotting arguments to adjust features of your plot.
# For example, change `pch` (plot character) to get filled points and `cex`
# (character expansion) to increase their size.

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  pch = 16,
  cex = 2
)

# We can add alpha transparency for overlapping points

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  pch = 16,
  cex = 2,
  alpha = 0.3
)

# To get filled points with a common solid background color, use an 
# appropriate plotting character (21:25) and combine with one of the special
# `bg` convenience arguments.
tinyplot(
  Temp ~ Day | Month,
  data = aq,
  pch = 21,     # use filled circles
  cex = 2,
  bg = 0.3,     # numeric in [0,1] adds a grouped background fill with transparency
  col = "black" # override default color mapping; give all points a black border
)

# Converting to a grouped line plot is a simple matter of adjusting the
# `type` argument.

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  type = "l"
)

# Similarly for other plot types, including some additional ones provided
# directly by tinyplot, e.g. density plots or internal plots (ribbons, 
# pointranges, etc.)

tinyplot(
  ~ Temp | Month,
  data = aq,
  type = "density",
  fill = "by"
)

# Facet plots are supported too. Facets can be drawn on their own...

tinyplot(
  Temp ~ Day,
  facet = ~ Month, 
  data = aq,
  type = "area",
  main = "Temperatures by month"
)

# ... or combined/contrasted with the by (colour) grouping.

aq = transform(aq, Summer = Month \%in\% c("Jun", "Jul", "Aug"))
tinyplot(
  Temp ~ Day | Summer,
  facet = ~ Month, 
  data = aq,
  type = "area",
  palette = "dark2",
  main = "Temperatures by month and season"
)

# Users can override the default square window arrangement by passing `nrow`
# or `ncol` to the helper facet.args argument. Note that we can also reduce
# axis label repetition across facets by turning the plot frame off.

tinyplot(
  Temp ~ Day | Summer,
  facet = ~ Month, facet.args = list(nrow = 1),
  data = aq,
  type = "area",
  palette = "dark2",
  frame = FALSE,
  main = "Temperatures by month and season"
)

# Use a two-sided formula to arrange the facet windows in a fixed grid.
# LHS -> facet rows; RHS -> facet columns

aq$hot = ifelse(aq$Temp>=75, "hot", "cold")
aq$windy = ifelse(aq$Wind>=15, "windy", "calm")
tinyplot(
 Temp ~ Day,
 facet = windy ~ hot,
 data = aq
)

# The (automatic) legend position and look can be customized using
# appropriate arguments. Note the trailing "!" in the `legend` position
# argument below. This tells `tinyplot` to place the legend _outside_ the plot
# area.

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  type = "l",
  legend = legend("bottom!", title = "Month of the year", bty = "o")
)

# The default group colours are inherited from either the "R4" or "Viridis"
# palettes, depending on the number of groups. However, all palettes listed
# by `palette.pals()` and `hcl.pals()` are supported as convenience strings,
# or users can supply a valid palette-generating function for finer control

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  type = "l",
  palette = "tableau"
)

# It's possible to further customize the look of you plots using familiar
# arguments and base plotting theme settings (e.g., via `(t)par`).

tpar(family = "HersheySans", las = 1)
tinyplot(
  Temp ~ Day | Month,
  data = aq,
  type = "b", pch = 16,
  palette = "tableau", alpha = 0.5,
  main = "Daily temperatures by month",
  frame = FALSE, grid = TRUE
)

# Note: For more examples and a detailed walkthrough, please see the
# introductory tinyplot tutorial available online:
# https://grantmcdermott.com/tinyplot/vignettes/intro_tutorial.html

}
