% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_errorbar.R, R/type_pointrange.R
\name{type_errorbar}
\alias{type_errorbar}
\alias{type_pointrange}
\title{Error bar and pointrange plot types}
\usage{
type_errorbar(length = 0.05)

type_pointrange()
}
\arguments{
\item{length}{length of the edges of the arrow head (in inches).}
}
\description{
Type function(s) for producing error bar and pointrange plots.
}
\examples{
mod = lm(mpg ~ wt * factor(am), mtcars)
coefs = data.frame(names(coef(mod)), coef(mod), confint(mod))
colnames(coefs) = c("term", "est", "lwr", "upr")

op = tpar(pch = 19)
 
# "errorbar" and "pointrange" type convenience strings
with(
  coefs,
  tinyplot(x = term, y = est, ymin = lwr, ymax = upr, type = "errorbar")
)
with(
  coefs,
  tinyplot(x = term, y = est, ymin = lwr, ymax = upr, type = "pointrange")
)

# Use `type_errorbar()` to pass extra arguments for customization
with(
  coefs,
  tinyplot(x = term, y = est, ymin = lwr, ymax = upr, type = type_errorbar(length = 0.2))
)

tpar(op)

}
