% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_rect.R
\name{type_rect}
\alias{type_rect}
\title{Rectangle plot type}
\usage{
type_rect()
}
\description{
Type function for plotting rectangles.
}
\details{
Contrary to base \code{\link[graphics]{rect}}, rectangles in
\link{tinyplot} must be specified using the \code{xmin}, \code{ymin},\code{xmax}, and \code{ymax}
arguments.
}
\examples{
i = 4*(0:10)

# "rect" type convenience character string
tinyplot(
  xmin = 100+i, ymin = 300+i, xmax = 150+i, ymax = 380+i,
  by = i, fill = 0.2,
  type = "rect"
)

# Same result with type_rect()
tinyplot(
  xmin = 100+i, ymin = 300+i, xmax = 150+i, ymax = 380+i,
  by = i, fill = 0.2,
  type = type_rect()
)

}
