% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeJUnit.R
\name{writeJUnit}
\alias{writeJUnit}
\title{Write the results of a \code{tinytests}-object into JUnit xml report.}
\usage{
writeJUnit(tinytests, file, overwrite = TRUE)
}
\arguments{
\item{tinytests}{\code{tinytests}-object to convert to JUnit xml.}

\item{file}{\code{character(1)}: Full file path to the .xml file to write the JUnit xml to.
Example: "/home/user/documents/results.xml".}

\item{overwrite}{\code{logical(1)}: should the file be overwritten if it already exist?
By default TRUE.}
}
\value{
\code{invisible: TRUE}.
}
\description{
Write the \code{tinytests}-object to a JUnit XML reporting file.
}
\section{Side-effects}{

Side effects are registered as a tests in the JUnit output and have been given a status
"SIDE-EFFECT". The call and diff is also returned in the standard-output of the testcase tag.

They are however not considered as failures and would thus not stop a pipeline.
}

\section{Errors}{

In case of overwrite = FALSE and the file already exists an error is thrown.
}

\examples{
# Run tests with `tinytest`
dirWithTests <- system.file("example_tests/multiple_files",package = "tinytest2JUnit")
testresults <- tinytest::run_test_dir(dirWithTests, verbose = FALSE)
# temporary output file to save JUnit XML to
tmpFile <- tempfile(fileext = ".xml")
writeJUnit(tinytests = testresults, file = tmpFile)
}
\seealso{
The JUnit XML report format:  \url{https://llg.cubic.org/docs/junit/}
}
