% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTippingPointData.R
\name{createTippingPointData}
\alias{createTippingPointData}
\title{Create data frame ready to use for tipping point analysis.}
\usage{
createTippingPointData(newTrialData, posterior, mapPrior, metaAnalysis = NULL)
}
\arguments{
\item{newTrialData}{A data frame containing information about the target population. See \code{createNewTrialData()}.}

\item{posterior}{A mixture combining MAP prior and target population. See \code{createPosteriorData()}.}

\item{mapPrior}{A robust MAP prior created by \code{RBesT::automixfit()}.}

\item{metaAnalysis}{A data frame containing a meta-analysis of trial(s) to be borrowed from. See \code{createPriorData()}.}
}
\value{
A data frame ready to be used for \code{tippingPointPlot()} and \code{getTippingPoint()}
}
\description{
Combines new trial data created by \code{createTargetData()}, a posterior distribution created by \code{createPosteriorData()} and a
robust MAP prior using \code{RBesT::automixfit()} and an optional meta-analysis created using the \code{meta} package into a data frame
needed for the functions \code{tippingPointPlot()} and \code{getTippingPoint()}.
}
\examples{

# specify new trial data
newTrialData <- createNewTrialData(nTotal = 30, treatmentEffectEstimate = 1.5, standardError = 2.1)

# read MAP prior
mapPrior <- loadTipmapData("tipmapPrior.rds")

# read posterior
posterior <- loadTipmapData("tipPost.rds")

tipdat <- createTippingPointData(
  newTrialData = newTrialData, posterior = posterior,
  mapPrior = mapPrior
)

}
\seealso{
\code{\link{createNewTrialData}}, \code{\link{createPosteriorData}}, \code{\link[RBesT:automixfit]{RBesT::automixfit}},
\code{\link{tippingPointPlot}}, \code{\link{getTippingPoint}}
}
