% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPosteriorData.R
\name{createPosteriorData}
\alias{createPosteriorData}
\title{Creates posterior distributions for a range of weights on the informative component of the robust MAP prior}
\usage{
createPosteriorData(mapPrior, newTrialData, sigma, nullTreatmentEffect = 0)
}
\arguments{
\item{mapPrior}{A MAP prior containing information about the trial(s) in the source population, created using \code{RBesT}.}

\item{newTrialData}{A vector containing information about the new trial. See \code{createNewTrialData()}.}

\item{sigma}{Standard deviation to be used for the weakly informative component of the MAP prior, recommended to be the unit-information standard deviation.}

\item{nullTreatmentEffect}{The mean of the robust component of the MAP prior. Defaults to 0.}
}
\value{
A data frame containing posterior distributions for varying weights
}
\description{
Returns a data frame containing the default quantiles of posterior mixture distributions
generated with varying weights on the informative component of the MAP prior.
}
\examples{

# create vector for new observations
newTrialData <- createNewTrialData(
  nTotal = 30, treatmentEffectEstimate = 1.27,
  standardError = 0.95
)

# read MAP prior created by RBesT
mapPrior <- loadTipmapData("tipmapPrior.rds")

# create posterior data
posteriorData <- createPosteriorData(
  mapPrior = mapPrior,
  newTrialData = newTrialData, sigma = 12
)
}
\references{
Best, N., Price, R. G., Pouliquen, I. J., & Keene, O. N. (2021).
Assessing efficacy in important subgroups in confirmatory trials: An example
using Bayesian dynamic borrowing. Pharm Stat, 20(3), 551–562.
https://doi.org/10.1002/pst.2093
}
\seealso{
\code{\link{createNewTrialData}}, \code{\link{createPriorData}}, \code{\link[RBesT:automixfit]{RBesT::automixfit}}
}
