% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tippingPointPlot.R
\name{tippingPointPlot}
\alias{tippingPointPlot}
\title{Visualize tipping point analysis}
\usage{
tippingPointPlot(
  tippingPointData,
  nullTreatmentEffect = 0,
  targetPopLabel = "Trial in target\\n population",
  yRange = NULL,
  yBreaks = NULL,
  title = NULL,
  ylab = "Endpoint",
  xlab = "Weight on informative component",
  mapPriorLabel = "MAP \\nprior",
  metaAnalysisLabel = "MA",
  legendLabel = "Posterior quantile"
)
}
\arguments{
\item{tippingPointData}{A data frame containing tipping point data, generated by \code{createTippingPointData()}.}

\item{nullTreatmentEffect}{The null treatment effect, determining where tipping points are calculated. Defaults to 0.}

\item{targetPopLabel}{A label for the trial in the target population.}

\item{yRange}{An optional argument specifying range of the y axis.}

\item{yBreaks}{An optional vector specifying breaks on the y axis.}

\item{title}{The plot title.}

\item{ylab}{The label for the y axis. Defaults to "Endpoint".}

\item{xlab}{The label for the x axis. Defaults to "Weight on informative component".}

\item{mapPriorLabel}{The label for the MAP prior. Defaults to "MAP prior"}

\item{metaAnalysisLabel}{An optional label for a meta-analysis (if included).}

\item{legendLabel}{An optional label for the plot legend. Defaults to "Posterior quantile".}
}
\value{
A \code{ggplot} object of the tipping point plot
}
\description{
Uses a data frame created by \code{createTippingPointData()} to visualize the tipping point analysis.
}
\examples{

tipdat <- loadTipmapData("tipdat.rds")

tippingPointPlot(tipdat)
}
\seealso{
\code{\link{createTippingPointData}}
}
