% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tipping_points.R
\name{get_tipping_points}
\alias{get_tipping_points}
\title{Identify tipping point for a specific quantile.}
\usage{
get_tipping_points(tipmap_data, quantile, null_effect = 0)
}
\arguments{
\item{tipmap_data}{A data frame created by \code{create_tipmap_data()}.}

\item{quantile}{The quantile(s) of the tipping point. Possible values are 0.025, 0.05, 0.1, 0.2, 0.8, 0.9, 0.95 and 0.975.}

\item{null_effect}{The null treatment effect. Defaults to 0.}
}
\value{
The weight closest to the tipping point for the specified quantile
}
\description{
Identifies the weights closest to tipping points for specified quantiles.
}
\examples{
tip_dat <- load_tipmap_data("tipdat.rds")#'
get_tipping_points(tip_dat, quantile = 0.025)
get_tipping_points(tip_dat, quantile = c(0.025, 0.05, 0.1, 0.2), null_effect = 0.1)

}
\seealso{
\code{\link{create_tipmap_data}}
}
