% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observed_bias_tip.R
\name{observed_bias_tip}
\alias{observed_bias_tip}
\title{Create a data frame to combine with an observed bias data frame demonstrating a hypothetical unmeasured confounder}
\usage{
observed_bias_tip(
  tip,
  point_estimate,
  lb,
  ub,
  tip_desc = "Hypothetical unmeasured confounder"
)
}
\arguments{
\item{tip}{Numeric. Value you would like to tip to.}

\item{point_estimate}{Numeric. Result estimate from the full model.}

\item{lb}{Numeric. Result lower bound from the full model.}

\item{ub}{Numeric. Result upper bound from the full model.}

\item{tip_desc}{Character. A description of the tipping point.}
}
\value{
A data frame with five columns:
\itemize{
\item \code{dropped}: the input from \code{tip_desc}
\item \code{type}: Explanation of \code{dropped}, here \code{tip} to clarify that this was calculated as a tipping point.
\item \code{point_estimate}: the shifted point estimate
\item \code{lb}: the shifted lower bound
\item \code{ub}: the shifted upper bound
}
}
\description{
Create a data frame to combine with an observed bias data frame demonstrating a hypothetical unmeasured confounder
}
