% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{setCoef}
\alias{setCoef}
\alias{getCoef}
\alias{tk2usr}
\alias{usr2tk}
\title{Functions to Convert Tk and User Coordinates}
\usage{
setCoef(W, width, height)
getCoef(W)
tk2usr(W, x = NULL, y = NULL)
usr2tk(W, x = NULL, y = NULL)
}
\arguments{
\item{W}{the window (toplevel). If W is missing the getCoef function returns the coefficients for the last toplevel visited.}

\item{width}{width of the canvas (image)}

\item{height}{height of the canvas (image)}

\item{x}{x position.}

\item{y}{y position.}
}
\description{
Convert Tk coordinates from/to user coordinates.
}
\examples{
\dontshow{
if (.isTclImgOk()){
bb <- 1
tt <- tktoplevel()
tt <- tkRplot(tt, function() {
 x <- 1:20 / 20
   plot(
   x,
   x ^ bb,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", bb),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = bb)
     points(x,
      x ^ bb,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })

 getCoef()

 tkbind(tt$env$canvas, "<Button-1>", function(x, y)
 print(tk2usr(x, y)))

 # A more complex example
 local({
 canPos <-.Tcl(paste(tt$env$canvas, "create text 0 0 "))
 canPosX <-.Tcl(paste(tt$env$canvas, "create text 0 0 "))
 canPosY <-.Tcl(paste(tt$env$canvas, "create text 0 0 "))
 lineVertical <- .Tcl(paste(tt$env$canvas, "create line 0 0 0 0"))
 lineHorizontal<-.Tcl(paste(tt$env$canvas, "create line 0 0 0 0"))
 tkbind(tt, "<Motion>", function (x, y) {
   x <- as.numeric(x)
     y <- as.numeric(y)
       for (i in c(canPos, lineVertical, lineHorizontal,canPosX,canPosY))
       tkdelete(tt$env$canvas, tclvalue(i))
            xy <- formatC(tk2usr(x, y),
                            digits = 2,
                             format = "f",
                              width = 5)

xRange <- tt$env$plt[1:2] * tt$env$width
  yRange <- (1 - tt$env$plt[4:3]) * tt$env$height
    canPos <<- .Tcl(
 paste(tt$env$canvas, "create text 40 10 -fill blue -justify left -text { ",
     xy[1], " ", xy[2],
     "} -font {Helvetica -10}"))
      if (x < xRange[1] | x > xRange[2])
         return()
         if (y < yRange[1] | y > yRange[2])
           return()
canPosX <<- .Tcl(paste(tt$env$canvas, "create text ", x, yRange[1]-10,
           " -fill blue -justify center -text { ",xy[1],
           "} -font {Helvetica -10}"))
canPosY <<- .Tcl(paste(tt$env$canvas, "create text ",xRange[2]+10, y,
   " -fill blue -justify center -text { ",xy[2], "} -font {Helvetica -10}"))
           lineVertical <<- .Tcl(paste(tt$env$canvas, "create line ",
                 x,      yRange[1],      x,      yRange[2],
                    "-fill blue -dash 4"))
           lineHorizontal <<- .Tcl(paste(tt$env$canvas,
                 "create line ",
                  xRange[1],  y, xRange[2], y,
                        "-fill blue -dash 4"))})
     tkbind(tt$env$canvas, "<Leave>", function (x, y)
     {tkdelete(tt$env$canvas, tclvalue(canPos))})
     } )
     Sys.sleep(1)
     tkdestroy(tt)
}
}
\dontrun{

bb <- 1
tt <- tktoplevel()
tt <- tkRplot(tt, function() {
 x <- 1:20 / 20
   plot(
   x,
   x ^ bb,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", bb),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = bb)
     points(x,
      x ^ bb,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })

 getCoef()

 tkbind(tt$env$canvas, "<Button-1>", function(x, y)
 print(tk2usr(x, y)))

 # A more complex example
 local({
 canPos <-.Tcl(paste(tt$env$canvas, "create text 0 0 "))
 canPosX <-.Tcl(paste(tt$env$canvas, "create text 0 0 "))
 canPosY <-.Tcl(paste(tt$env$canvas, "create text 0 0 "))
 lineVertical <- .Tcl(paste(tt$env$canvas, "create line 0 0 0 0"))
 lineHorizontal<-.Tcl(paste(tt$env$canvas, "create line 0 0 0 0"))
 tkbind(tt, "<Motion>", function (x, y) {
   x <- as.numeric(x)
     y <- as.numeric(y)
       for (i in c(canPos, lineVertical, lineHorizontal,canPosX,canPosY))
       tkdelete(tt$env$canvas, tclvalue(i))

            xy <- formatC(tk2usr(x, y),
                            digits = 2,
                             format = "f",
                              width = 5)

xRange <- tt$env$plt[1:2] * tt$env$width
  yRange <- (1 - tt$env$plt[4:3]) * tt$env$height
    canPos <<- .Tcl(
 paste(tt$env$canvas, "create text 40 10 -fill blue -justify left -text { ",
     xy[1], " ", xy[2],
     "} -font {Helvetica -10}"))
      if (x < xRange[1] | x > xRange[2])
         return()
         if (y < yRange[1] | y > yRange[2])
           return()
canPosX <<- .Tcl(paste(tt$env$canvas, "create text ", x, yRange[1]-10,
           " -fill blue -justify center -text { ",xy[1],
           "} -font {Helvetica -10}"))
canPosY <<- .Tcl(paste(tt$env$canvas, "create text ",xRange[2]+10, y,
   " -fill blue -justify center -text { ",xy[2], "} -font {Helvetica -10}"))
           lineVertical <<- .Tcl(paste(tt$env$canvas, "create line ",
                 x,      yRange[1],      x,      yRange[2],
                    "-fill blue -dash 4"))
           lineHorizontal <<- .Tcl(paste(tt$env$canvas,
                 "create line ",
                  xRange[1],  y, xRange[2], y,
                        "-fill blue -dash 4"))})
     tkbind(tt$env$canvas, "<Leave>", function (x, y)
     {tkdelete(tt$env$canvas, tclvalue(canPos))})
     } )

 }
}
