% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_tmap.R
\name{save_tmap}
\alias{save_tmap}
\title{Save tmap}
\usage{
save_tmap(tm, filename = shp_name(tm), width = par("din")[1],
  height = par("din")[2], units = c("in", "cm", "mm"), dpi = 300,
  outer.margins = 0, asp = 0, scale = NA, ...)
}
\arguments{
\item{tm}{tmap object}

\item{filename}{filename including extension, and optionally the path. The extensions pdf, eps, svg, wmf (Windows only), png, jpg, bmp, or tiff are supported. Use \code{\link{itmap}} to create an interactive svg.}

\item{width}{width. Defaults to the width of current plotting window. Units are set with the argument \code{units}.}

\item{height}{height. Defaults to the height of current plotting window. Units are set with the argument \code{units}.}

\item{units}{units for width and height when either one is explicitly specified (in, cm, or mm)}

\item{dpi}{dots per inch. Only applicable for raster graphics.}

\item{outer.margins}{overrides the outer.margins argument of \code{\link{tm_layout}} (unless set to \code{NA})}

\item{asp}{overrides the asp argument of \code{\link{tm_layout}} (unless set to \code{NA})}

\item{scale}{overrides the scale argument of \code{\link{tm_layout}} (unless set to \code{NA})}

\item{...}{arguments passed on to device functions}
}
\description{
Save tmap to a file, such as png, jpg, or pdf.
}
\examples{
\dontrun{
data(NLD_muni, NLD_prov)
(tm_shape(NLD_muni) +
	 tm_fill(col="population", convert2density=TRUE, 
	   style="kmeans", title="Population (per km2)", legend.hist=FALSE) +
	 tm_borders("black", alpha=.5) + 
tm_shape(NLD_prov) +
	 tm_borders("grey25", lwd=2) +
tm_format_NLD(inner.margins = c(.02, .15, .06, .15)) + 
tm_scale_bar(position = c("left", "bottom")) +
tm_compass(position=c("right", "bottom")) + 
tm_style_classic()) \%>\% save_tmap()
}
}

