

.defaultTmapOptions = structure(
	list(
		# mode specific options or default values
		modes = list(plot = list(name = "Grid",
								 use_gradient = FALSE),
								 #crs = "auto"),
					 view = list(name = "Leaflet",
					 			use_browser = FALSE,
					 			use_WebGL = NA,
					 			legend.position = tm_pos_in(pos.h = "right", pos.v = "bottom", align.h = "left", align.v = "top", just.h = "left", just.v = "bottom"),
					 			#crs_data = list(dimensions = 3857, 4326),
					 			facet.max = 16,
					 			#legend.bg.alpha = 0.8,
					 			#view.legend.position = c("right", "top"),
					 			control.position = c("left", "top"),
					 			control.collapse = TRUE,
					 			basemap.show = TRUE,
					 			set_bounds = FALSE,
					 			set_view = NA,
					 			set_zoom_limits = NA,
					 			qtm.scalebar = TRUE,
					 			qtm.minimap = FALSE,
					 			qtm.mouse_coordinates = TRUE,
					 			use_circle_markers = TRUE,
					 			leaflet.options = list())),

		crs = NA,

		# facets
		facet.max = 64, # was max.facets
		facet.flip = FALSE,
		free.scales = NULL, # for backward compatibility: if this value is set, it will be used to impute the free arguments in the layer functions

		# spatial object class specific options
		raster.max_cells = 1e7, # was max.raster
		raster.warp = TRUE,

		# general
		show.messages = TRUE,
		show.warnings = TRUE,

		# output
		output.format = "png",
		output.size = 49,
		output.dpi = 300,
		animation.dpi = 100,

		# default visual variable values
		value.const = list(fill.polygons = "grey85",
						   fill.symbols = "grey60",
						   fill.dots = "black",
						   col.polygons = "grey25",
						   col.symbols = "grey25",
						   col.raster = "grey40",
						   col.text = "black",
						   col = "black",
						   bgcol.labels_highlighted = "white",
						   bgcol = "#00000000",
						   lwd = 1,
						   lty = "solid",
						   text = "Abc",
						   text.labels = "",
						   fontface = NULL,
						   shape.symbols = 21,
						   shape.bubbles = 21,
						   shape.squares = 22,
						   shape.dots = 19,
						   shape.markers = marker_icon(),
						   size.symbols = 1,
						   size.bubbles = 1.3333,
						   size.squares = 1.3333,
						   size.dots = .3,
						   size.text = 1,
						   fill_alpha = 1,
						   col_alpha = 1,
						   bgcol_alpha = 1,
						   angle = 0,
						   num = 1),
		value.na = list(
			fill = "grey75",
			col = "grey75",
			col.raster = "#00000000",
			bgcol = "grey75",
			lty = "solid",
			text = "Unknown",
			fontface = NULL,
			fill_alpha = 1,
			col_alpha = 1,
			bgcol_alpha = 1,
			col_alpha.raster = 0,
			angle = 0
		),
		value.null = list(
			fill = "grey95",
			col = "grey95",
			col.polygons = "grey40",
			bgcol = "grey95",
			lty = "solid",
			lwd = 0.2,
			shape = 20,
			text = "",
			fontface = NULL,
			fill_alpha = 1,
			col_alpha = 1,
			bgcol_alpha = 1,
			size = 0.2,
			angle = 0,
			num = 0
		),
		value.blank = list(
			fill = "#00000000",
			col = "#00000000",
			bgcol = "#00000000",
			lty = "blank",
			lwd = 0,
			text = "",
			fontface = NULL,
			fill_alpha = 0,
			col_alpha = 0,
			bgcol_alpha = 0,
			angle = 0,
			num = 0
		),
		values.var = list(fill = list(seq = "-hcl.blues3", div = "pu_gn_div",
									  unord = "cols4all.area7", ord = "-hcl.blues3", cyc = "tol.rainbow_pu_rd", biv = "pu_gn_bivs"),
						  col = list(seq = "-hcl.blues3", div = "pu_gn_div",
						  		   unord = "cols4all.line7", ord = "-hcl.blues3", cyc = "tol.rainbow_pu_rd", biv = "pu_gn_bivs"),
						  fill.dots = list(seq = "-hcl.blues3", div = "pu_gn_div",
						  				 unord = "cols4all.line7", ord = "-hcl.blues3", cyc = "tol.rainbow_pu_rd", biv = "pu_gn_bivs"),
						  bgcol = list(seq = "-hcl.blues3", div = "pu_gn_div",
						  			 unord = "cols4all.area7", ord = "-hcl.blues3", cyc = "tol.rainbow_pu_rd", biv = "pu_gn_bivs"),
						  size = tm_seq(0, 1, power = "sqrt"),
						  size.bubbles = tm_seq(0, 1, power = "sqrt"),
						  lwd = c(0, 3),
						  lty = c("dashed", "dotted", "dotdash", "longdash", "twodash"),
						  text = LETTERS,
						  fontface = c("plain", "italic", "bold"),
						  fill_alpha = c(0.25, 1),
						  col_alpha = c(0.25, 1),
						  bgcol_alpha = c(0.25, 1),
						  shape = 21:25,
						  area = c(0, 1),
						  xmod = c(0, 1),
						  ymod = c(0, 1),
						  angle = c(0, 360),
						  num = c(0, 1)),
		values.range = list(fill = NA, col = NA, size = c(0, 1), lwd = c(0, 1),
							lty = NA, text = NA, fontface = NA, fill_alpha = NA,
							col_alpha = NA, shape = NA, angle = NA, num = c(0,1)), # NA = automatic, NULL is not applicable
		value.neutral = list(size = 0.75,
							 lwd = 2,
							 lty = "solid",
							 fill_alpha = 1,
							 col_alpha = 1,
							 bgcol_alpha = 1,
							 text = "Abc",
							 fontface = "plain",
							 angle = 0,
							 num = 1),
		values.scale = list(
			1,
			lwd.lines = 1,
			size.symbols = 1,
			size.bubbles = 1.3333,
			size.squares = 1.3333
		),

		# scales
		scales.var = list(fill = list(fact = "categorical", num = "intervals", int = "discrete"),
						  col = list(fact = "categorical", num = "intervals", int = "discrete"),
						  bgcol = list(fact = "categorical", num = "intervals", int = "discrete"),
						  lwd = list(fact = "categorical", num = "continuous", int = "discrete"),
						  lty = list(fact = "categorical", num = "intervals"),
						  shape = list(fact = "categorical", num = "intervals"),
						  size = list(fact = "continuous", num = "continuous"),
						  fill_alpha = list(fact = "categorical", num = "intervals"),
						  col_alpha = list(fact = "categorical", num = "intervals"),
						  bgcol_alpha = list(fact = "categorical", num = "intervals"),
						  area = list(fact = "categorical", num = "continuous"),
						  xmod = list(fact = "asis", num = "asis"),
						  ymod = list(fact = "asis", num = "asis"),
						  angle = list(fact = "asis", num = "asis"),
						  text = list(fact = "asis", num = "asis"),
						  fontface = list(fact = "categorical", num = "categorical")),

		scale.misc.args = list(continuous = list(n = c(fill = 5, col = 5, 5), outliers.trunc = c(FALSE, FALSE), trans = "identity", limits = list(fill = NA, col = NA, 0)),
							   continuous_log = list(n = c(fill = 5, col = 5, 5), outliers.trunc = c(FALSE, FALSE),	limits = list(fill = NA, col = NA, NA)),
							   continuous_log2 = list(n = c(fill = 5, col = 5, 5), outliers.trunc = c(FALSE, FALSE),	limits = list(fill = NA, col = NA, NA)),
							   continuous_log10 = list(n = c(fill = 5, col = 5, 5), outliers.trunc = c(FALSE, FALSE),	limits = list(fill = NA, col = NA, NA)),
							   continuous_log1p = list(n = c(fill = 5, col = 5, 5), outliers.trunc = c(FALSE, FALSE),	limits = list(fill = NA, col = NA, NA)),
							   continuous_sqrt = list(n = c(fill = 5, col = 5, 5), outliers.trunc = c(FALSE, FALSE),	limits = list(fill = NA, col = NA, 0)),
							   continuous_pseudo_log = list(n = c(fill = 5, col = 5, 5), outliers.trunc = c(FALSE, FALSE),	limits = list(fill = NA, col = NA, NA)),
							   rank = list(n = 5,
							   			unit = "rank")), # NA means take data range, 0 means include 0


		continuous.nclass_per_legend_break = 50, # the number of continuous legend breaks within one 'unit' (label).
		continuous.nclasses = 101, # the number of classes of a continuous scale. Should be odd

		# labels
		label.format = list(
			fun = NULL,
			scientific = FALSE,
			digits = NA,
			big.num.abbr = c(mln = 6, bln = 9),
			prefix = "",
			suffix = "",
			text.separator = "to",
			text.less.than = c("Less", "than"),
			text.or.more = c("or", "more"),
			text.align = NA,
			text.to.columns = FALSE,
			html.escape = TRUE
		),
		label.na = "Missing",


		###############################3
		# tm_layout options
		###############################3
		scale = 1,
		asp = NA,

		# background
		bg.color = NA,
		outer.bg.color = NA,

		# frame
		frame = TRUE,
		frame.lwd = 1,
		frame.r = 2,
		frame.double_line = FALSE,


		# margins
		outer.margins = rep(0.02, 4),
		inner.margins = list(stars = rep(0, 4), SpatRaster = rep(0, 4), rep(0.02, 4)),
		inner.margins.extra = c(0, 0, 0, 0),
		meta.margins = NA,
		meta.auto_margins = c(0.4, 0.4, 0.4, 0.4),
		between_margin = 0.5,
		panel.margin = c(xtab = 0.4, 0),
		component.offset = c(inside = 0.75, INSIDE = 0, outside = 0, OUTSIDE = 0),
		component.stack_margin = 0,
		grid.mark.height = 2,
		xylab.height = 1.25,
		coords.height = 1.25,

		# xlab, ylab
		xlab.show = FALSE,
		xlab.text = "",
		xlab.size = 1,
		xlab.color = "black",
		xlab.rotation = 0,
		xlab.space = 0,
		xlab.fontface = NULL,
		xlab.fontfamily = NULL,
		xlab.alpha = 1,
		xlab.side = "bottom",

		ylab.show = FALSE,
		ylab.text = "",
		ylab.size = 1,
		ylab.color = "black",
		ylab.rotation = 0,
		ylab.space = 0,
		ylab.fontface = NULL,
		ylab.fontfamily = NULL,
		ylab.alpha = 1,
		ylab.side = "left",


		# panel
		panel.type = NA, # "wrap" or "xtab",
		panel.wrap.pos = "top", # or "left", "right", "bottom"
		panel.xtab.pos = c("left", "top"),

		# data
		unit = "metric",

		# general visual settings

		# colors
		color.sepia_intensity = 0,
		color.saturation = 1,
		color_vision_deficiency_sim = "none",

		# text
		text.fontface = "plain",
		text.fontfamily = "",
		text.alpha = 1,

		component.position = list('in' = tm_pos_in(pos.h = "left", pos.v = "top",
											  align.h = "left", align.v = "top", just.h = "left", just.v = "top"),
								  out = tm_pos_out(cell.h = "right", cell.v = "center",
								  		   pos.h = "left", pos.v = "top",
								  		   align.h = "left", align.v = "top", just.h = "left", just.v = "top")),

		component.autoscale = TRUE,

		# legend
		legend.show = TRUE,
		legend.design = "standard",
		legend.orientation = "portrait",
		legend.position = tm_pos_auto_out(cell.h = "right", cell.v = "bottom",
										  pos.h = "left", pos.v = "top",
										  align.h = "left", align.v = "top", just.h = "left", just.v = "top"),
		legend.width = NA,
		legend.height = NA,
		legend.stack = c(all = "vertical", per_row = "horizontal", per_col = "horizontal", all_row = "vertical", all_col = "horizontal", manual = "vertical"),
		legend.group.frame = TRUE,
		legend.resize_as_group = FALSE,
		legend.reverse = FALSE,
		legend.na.show = NA,
		legend.title.color = NULL,
		legend.title.size = 0.9,
		legend.title.fontface = NULL,
		legend.title.fontfamily = NULL,
		legend.title.alpha = 1,
		legend.xlab.color = NULL,
		legend.xlab.size = 0.9,
		legend.xlab.fontface = NULL,
		legend.xlab.fontfamily = NULL,
		legend.xlab.alpha = 1,
		legend.ylab.color = NULL,
		legend.ylab.size = 0.9,
		legend.ylab.fontface = NULL,
		legend.ylab.fontfamily = NULL,
		legend.ylab.alpha = 1,
		legend.text.color = NULL,
		legend.text.size = 0.7,
		legend.text.fontface = NULL,
		legend.text.fontfamily = NULL,
		legend.text.alpha = 1,
		legend.frame = TRUE,
		legend.frame.lwd = 1,
		legend.frame.r = 2,
		legend.bg.color = NA,
		legend.bg.alpha = 1,
		legend.only = FALSE,
		legend.absolute_fontsize = 14,
		legend.settings.standard.portrait = list(item.height = c(rect = 1.2, symbols = 1, gradient = 3, lines = 1.2, text = 1.2, bivariate = 1.2),
												 item.width = c(rect = 1.2, symbols = 1, gradient = 1.2, lines = 1.2, text = 3, bivariate = 1.2),
												 item.r = 2,
												 item.space = c(rect = 0.2, symbols = 0.2, gradient = 0, lines = 0.2, text = 0.2, bivariate = 0),
												 item.na.height = c(rect = NA, symbols = NA, gradient = 1.2, lines = NA, text = NA, bivariate = NA),
												 item.na.width = c(rect = NA, symbols = NA, gradient = 1.2, lines = NA, text = NA, bivariate = NA),
												 item.na.space = c(rect = 0.2, symbols = 0.3, gradient = 1, lines = 0.2, text = 0.2, bivariate = 0.2),
												 item.shape = 107,
												 title.padding  = c(0, 0, 0.25, 0),
												 xlab.padding = c(0, 0, 0.25, 0),
												 ylab.padding = c(0, 0, 0.25, 0),
												 title.align = c(bivariate = "right", "left"),
												 xlab.align = "left",
												 ylab.align = "center",
												 ticks = list(rect = list(), symbols = list(), gradient = list(c(1, 1.5)), lines = list(), text = list(), bivariate = list()),
												 ticks.disable.na = c(rect = FALSE, symbols = FALSE, gradient = TRUE, lines = FALSE, text = FALSE, bivariate = TRUE),
												 ticks.col = NA,
												 ticks.lwd = 1.5,
												 margins = c(0.4, 0.4, 0.4, 0.4),
												 item_text.margin = 0.25),
		legend.settings.standard.landscape = list(item.height = c(rect = 1, symbols = 1, gradient = 1.2, lines = 1, text = 1),
												  item.width = c(rect = 6, symbols = 3, gradient = 6, lines = 6, text = 6),
												  item.r = 2,
												  item.space = c(rect = 0.2, symbols = 0.3, gradient = 0, lines = 0.2, text = 0.2),
												  item.na.height = c(rect = NA, symbols = NA, gradient = 2, lines = NA, text = NA),
												  item.na.width = c(rect = NA, symbols = NA, gradient = 4, lines = NA, text = NA),
												  item.na.space = c(rect = 0.2, symbols = 0.3, gradient = 0.3, lines = 0.2, text = 0.2),
												  item.shape = 107,

												  title.padding  = c(0, 0, 0.25, 0),
												  xlab.padding = c(0, 0, 0.25, 0),
												  ylab.padding = c(0, 0, 0.25, 0),
												  title.align = c(bivariate = "right", "left"),
												  xlab.align = "left",
												  ylab.align = "center",
												  ticks = list(rect = list(), symbols = list(), gradient = list(c(1, 1.2)), lines = list(), text = list()),
												  ticks.disable.na = c(rect = FALSE, symbols = FALSE, gradient = TRUE, lines = FALSE, text = FALSE),
												  ticks.col = NA,
												  ticks.lwd = 1.5,
												  margins = c(0.4, 0.4, 0.4, 0.4),
												  item_text.margin = 0.25),

		# charts
		chart.show = TRUE,
		chart.plot.axis.x = FALSE,
		chart.plot.axis.y = TRUE,
		chart.position = tm_pos_auto_out(cell.h = "right", cell.v = "bottom",
										 pos.h = "left", pos.v = "top",
										 align.h = "left", align.v = "bottom", just.h = "left", just.v = "top"),
		chart.width = c(histogram.min = 10,
						histogram.max = 20,
						bar.min = 10,
						bar.max = 20,
						donut.min = 10,
						donut.max = 10,
						heatmap.min = 10,
						heatmap.max = 15),
		chart.height = c(histogram.min = 10,
						 histogram.max = 10,
						 bar.min = 10,
						 bar.max = 10,
						 donut.min = 10,
						 donut.max = 10,
						 heatmap.min = 10,
						 heatmap.max = 10),
		chart.stack = c(all = "vertical", per_row = "horizontal", per_col = "horizontal", all_row = "vertical", all_col = "horizontal", manual = "vertical"),
		chart.group.frame = TRUE,
		chart.resize_as_group = FALSE,
		chart.reverse = FALSE,
		chart.na.show = NA,
		chart.title.color = NULL,
		chart.title.size = 0.9,
		chart.title.fontface = NULL,
		chart.title.fontfamily = NULL,
		chart.title.alpha = NULL,
		chart.xlab.color = NULL,
		chart.xlab.size = 0.9,
		chart.xlab.fontface = NULL,
		chart.xlab.fontfamily = NULL,
		chart.xlab.alpha = NULL,
		chart.ylab.color = NULL,
		chart.ylab.size = 0.9,
		chart.ylab.fontface = NULL,
		chart.ylab.fontfamily = NULL,
		chart.ylab.alpha = 1,
		chart.text.color = NULL,
		chart.text.size = 0.7,
		chart.text.fontface = NULL,
		chart.text.fontfamily = NULL,
		chart.text.alpha = 1,
		chart.frame = TRUE,
		chart.frame.lwd = 1,
		chart.frame.r = 2,
		chart.bg.color = NA,
		chart.bg.alpha = 1,
		chart.object.color = "#DDDDDD",

		# components
		title.size = 1.3,
		title.color = NULL,
		title.fontface = NULL,
		title.fontfamily = NULL,
		title.alpha = 1,
		title.bg.color = NA,
		title.bg.alpha = 1,
		title.padding = c(0.25, 0.25, 0.25, 0.25),

		title.frame = NA,
		title.frame.lwd = 1,
		title.frame.r = 2,
		title.stack = "vertical",
		title.position = tm_pos_out(cell.h = "center", cell.v ="top", pos.h = "left", pos.v = "top", align.h = "left", align.v = "top", just.h = "left", just.v = "bottom"),
		title.width = NA,
		title.group.frame = TRUE,
		title.resize_as_group = FALSE,

		credits.size = .7,
		credits.color = NA,
		credits.fontface = NULL,
		credits.fontfamily = NULL,
		credits.alpha = 1,
		credits.bg.color = NA,
		credits.bg.alpha = 1,
		credits.padding = c(0.25, 0.25, 0.25, 0.25),
		credits.frame = NA,
		credits.frame.lwd = 1,
		credits.frame.r = 2,
		credits.stack = "vertical",
		credits.position = tm_pos_in(pos.h = "right", pos.v = "bottom", align.h = "right", align.v = "top", just.h = "left", just.v = "bottom"),
		credits.width = NA,
		credits.height = NA,
		credits.group.frame = TRUE,
		credits.resize_as_group = FALSE,

		compass.north=0,
		compass.type="arrow",
		compass.text.size=.8,
		compass.size=NA,
		compass.show.labels=1,
		compass.cardinal.directions=c("N", "E", "S", "W"),
		compass.text.color=NA,
		compass.color.dark=NA,
		compass.color.light=NA,
		compass.lwd=1,
		compass.bg.color=NA,
		compass.bg.alpha=1,
		compass.margins = c(0.25, 0.25, 0.25, 0.25),

		# standard arguments:
		compass.stack = "vertical",
		compass.position = tm_pos_in(pos.h = "right", pos.v = "bottom", align.h = "right", align.v = "top", just.h = "left", just.v = "bottom"),
		compass.frame = NA,
		compass.frame.lwd = 1,
		compass.frame.r = 2,
		compass.group.frame = TRUE,
		compass.resize_as_group = FALSE,

		logo.height = 3,
		logo.margins = c(0.2, 0.2, 0.2, 0.2),
		logo.between_margin = 0.2,
		logo.stack = "vertical",
		logo.position = tm_pos_in(pos.h = "right", pos.v = "bottom", align.h = "right", align.v = "top", just.h = "left", just.v = "bottom"),
		logo.frame = NA,
		logo.frame.lwd = 1,
		logo.frame.r = 2,
		logo.group.frame = TRUE,
		logo.resize_as_group = FALSE,

		scalebar.breaks = NULL,
		scalebar.width = 12,
		scalebar.text.size = .5,
		scalebar.text.color = NA,
		scalebar.text.fontface = NULL,
		scalebar.text.fontfamily = NULL,
		scalebar.color.dark = "black",
		scalebar.color.light = "white",
		scalebar.lwd = 1,
		scalebar.bg.color = NA,
		scalebar.bg.alpha = 1,
		scalebar.size = NULL,
		scalebar.margins = c(0.01,0.01,0.01,0.01),

		# standard arguments:
		scalebar.stack = "vertical",
		scalebar.position = tm_pos_in(pos.h = "right", pos.v = "bottom", align.h = "right", align.v = "top", just.h = "left", just.v = "bottom"),
		scalebar.frame = NA,
		scalebar.frame.lwd = 1,
		scalebar.frame.r = 2,
		scalebar.group.frame = TRUE,
		scalebar.resize_as_group = FALSE,

		grid.show = FALSE,
		grid.labels.pos = c("left", "bottom"),
		grid.x=NA,
		grid.y=NA,
		grid.n.x=NA,
		grid.n.y=NA,
		grid.crs=NA,
		grid.col=NA,
		grid.lwd=1,
		grid.alpha=NA,
		grid.labels.show=TRUE,
		grid.labels.size=.6,
		grid.labels.col=NA,
		grid.labels.fontface=NULL,
		grid.labels.fontfamily=NULL,
		grid.labels.rot = c(0, 0),
		grid.labels.format = list(big.mark = ","),
		grid.labels.cardinal = FALSE,
		grid.labels.margin.x=0,
		grid.labels.margin.y=0,
		grid.labels.space.x=NA,
		grid.labels.space.y=NA,
		grid.labels.inside_frame=FALSE,
		grid.ticks = TRUE, #labels.show & !labels.inside_frame,
		grid.lines = TRUE,
		grid.ndiscr = 100,


		# standard arguments:
		# mouse.stack = "vertical",
		# mouse.position = tm_pos_in(pos.h = "right", pos.v = "bottom", align.h = "left", align.v = "top", just.h = "left", just.v = "bottom"),
		# mouse.frame = FALSE,
		# mouse.frame.lwd = 1,
		# mouse.frame.r = 2,
		# mouse.group.frame = TRUE,
		# mouse.resize_as_group = FALSE,
		#

		mouse_coordinates.stack = "vertical",
		mouse_coordinates.position = tm_pos_in(pos.h = "right", pos.v = "bottom", align.h = "right", align.v = "top", just.h = "left", just.v = "bottom"),

		minimap.server = NA,
		minimap.toggle = TRUE,
		minimap.stack = "vertical",
		minimap.position = tm_pos_in(pos.h = "right", pos.v = "bottom", align.h = "right", align.v = "top", just.h = "left", just.v = "bottom"),

		panel.show = NA, # depends on type: TRUE for facets
		panel.labels = NA,
		panel.label.size = 1,
		panel.label.color = "black",
		panel.label.fontface = NULL,
		panel.label.fontfamily = NULL,
		panel.label.alpha = 1,
		panel.label.bg.color = "grey80",
		panel.label.frame = TRUE,
		panel.label.frame.lwd = 1,
		panel.label.frame.r = 2,
		panel.label.height = 1,
		panel.label.rot = c(90, 0),

		#
		bbox = NULL,
		set_bounds = FALSE,
		set_view = NA,
		set_zoom_limits = NA,

		qtm.scalebar = FALSE,
		qtm.minimap = FALSE,
		qtm.mouse_coordinates = FALSE,

		earth_boundary = FALSE,
		earth_boundary.color = NULL,
		earth_boundary.lwd = 1,
		earth_datum = "OGC:CRS84",
		space.color = NULL,

		check_and_fix = FALSE,

		basemap.show = FALSE,
		basemap.server = c("Esri.WorldGrayCanvas", "OpenStreetMap", "Esri.WorldTopoMap"),
		basemap.alpha = 1,
		basemap.zoom = NA,

		tiles.show = FALSE,
		tiles.server = "",
		tiles.alpha = 1,
		tiles.zoom = NA,

		attr.color = "black",

		crs_extra = "",
		crs_global = "+proj=eqearth"
	),
	style = "white",
	specified = character()
)

styles = list(
	v3 = list(
		modes = list(view = list(legend.bg.alpha = 0.8)),
		value.na = list(
			fill = "grey75",
			col = "grey75",
			col.raster = "#00000000",
			lty = "solid",
			lwd = NA,
			text = "Unknown",
			fontface = "plain",
			fill_alpha = 1,
			col_alpha = 1,
			col_alpha.raster = 0
		),
		value.null = list(
			fill = "grey95",
			col = "grey95",
			col.polygons = "grey40",
			lty = "solid",
			lwd = 0.2,
			text = "",
			fontface = "plain",
			fill_alpha = 1,
			col_alpha = 1,
			size = 0.2
		),
		value.blank = list(
			fill = "#00000000",
			col = "#00000000",
			lty = "blank",
			lwd = 0,
			text = "",
			fontface = "plain",
			fill_alpha = 0,
			col_alpha = 0
		),
		values.var = list(fill = list(seq = "brewer.yl_or_br", div = "brewer.rd_yl_gn", unord = "brewer.set3", ord = "brewer.yl_or_br"),
						  col = list(seq = "brewer.yl_or_br", div = "brewer.rd_yl_gn", unord = "brewer.set3", ord = "brewer.yl_or_br")),
		frame.lwd = 1,
		frame.r = 0,
		title.position = tm_pos_in(pos.h = "left", pos.v = "top", align.h = "left", align.v = "top", just.h = "left", just.v = "bottom"),
		title.size = 1.3,
		legend.position = tm_pos_auto_in(align.h = "left", align.v = "top", just.h = "left", just.v = "bottom"),
		legend.text.size = 0.7,
		legend.title.size = 0.9,
		legend.frame = FALSE,
		legend.frame.r = 0,
		legend.settings.standard.portrait = list(item.height = c(rect = 1, symbols = 1, gradient = 1, bivariate = 1),
												 item.width = c(rect = 1, symbols = 1, gradient = 1.2, bivariate = 1),
												 item.r = 0,
												 item.space = c(rect = 0, symbols = 0, gradient = 0, bivariate = 0),
												 item.na.height = c(rect = NA, symbols = NA, gradient = 1.2, bivariate = 1),
												 item.na.width = c(rect = NA, symbols = NA, gradient = 1.2, bivariate = 1),
												 item.na.space = c(rect = 0, symbols = 0, gradient = 0, bivariate = 0),
												 title.padding  = c(0, 0, 0.25, 0),
												 ticks = list(rect = list(), symbols = list(), gradient = list(), bivariate = list()),
												 ticks.disable.na = c(rect = FALSE, symbols = FALSE, gradient = TRUE, bivariate = TRUE),
												 ticks.col = NA,
												 ticks.lwd = 1.5,
												 margins = c(0.4, 0.4, 0.4, 0.4),
												 item_text.margin = 0.25),
		legend.settings.standard.landscape = list(item.height = c(rect = 1, symbols = 1, gradient = 1.2),
												  item.width = c(rect = 6, symbols = 3, gradient = 6),
												  item.r = 0,
												  item.space = c(rect = 0.2, symbols = 0.3, gradient = 0),
												  item.na.height = c(rect = NA, symbols = NA, gradient = 2),
												  item.na.width = c(rect = NA, symbols = NA, gradient = 6),
												  item.na.space = c(rect = 0.2, symbols = 0.3, gradient = 0.3),
												  title.padding  = c(0, 0, 0.25, 0),
												  ticks = list(rect = list(), symbols = list(), gradient = list(c(0.8, 1))),
												  ticks.disable.na = c(rect = FALSE, symbols = FALSE, gradient = TRUE),
												  ticks.col = NA,
												  ticks.lwd = 1.5,
												  margins = c(0.4, 0.4, 0.4, 0.4),
												  item_text.margin = 0.25)
	),
	gray = list(
		bg.color = "grey85",
		value.const = list(fill = "grey70",
						   fill.dots = "black",
						   fill = "grey50",
						   col.polygons = "grey20",
						   col = "black")
	),
	grey = list(
		bg.color = "grey85",
		value.const = list(fill = "grey70",
						   fill.dots = "black",
						   fill = "grey50",
						   col.polygons = "grey20",
						   col = "black")
	),
	natural = list(
		bg.color = "lightskyblue1",
		value.const = list(fill.polygons = "darkolivegreen3",
						   fill.dots = "firebrick",
						   fill = "tomato2",
						   col.lines = "steelblue",
						   col.text = "white",
						   col = "black"),
		value.na = list(
			fill = "white",
			col = "white",
			col.raster = "white"),
		value.null = list(
			fill = "grey70",
			col = "grey70",
			col.polygons = "grey70"),
		values.var = list(fill = list(seq = "brewer.yl_gn", div = "brewer.rd_yl_gn", unord = "brewer.set3", ord = "brewer.yl_gn"),
						  col = list(seq = "brewer.yl_gn", div = "brewer.rd_yl_gn", unord = "brewer.set3", ord = "brewer.yl_gn")),
		attr.color = "black",
		space.color = "white",
		legend.frame = TRUE,
		legend.bg.color = "grey90",
		frame = FALSE,
		earth_boundary = TRUE,
		basemap.server = "Esri.NatGeoWorldMap",
		basemap.alpha = 1),
	cobalt = list(bg.color = "#002240",
				  outer.bg.color = "#002240",
				  value.const = list(fill.polygons = "#0088FF",
				  				   fill = "#FF9D00",
				  				   col.lines = "#FFEE80",
				  				   col.text = "white",
				  				   col = "#002240",
				  				   bgcol.labels_highlighted = "#002240",
				  				   bgcol = "#00000000"),
				  value.na = list(
				  	fill = "grey60",
				  	col = "grey60",
				  	col.raster = "grey60"),
				  value.null = list(
				  	fill = "grey40",
				  	col = "grey40",
				  	col.polygons = "grey40"),
				  values.var = list(fill = list(seq = "brewer.yl_gn", div = "brewer.rd_yl_gn", unord = "brewer.set3", ord = "brewer.yl_gn"),
				  				  col = list(seq = "brewer.yl_gn", div = "brewer.rd_yl_gn", unord = "brewer.set3", ord = "brewer.yl_gn")),
				  attr.color = "white",
				  chart.text.color = "white",
				  chart.title.color = "white",
				  basemap.server = "CartoDB.DarkMatter",
				  basemap.alpha = .5),
	albatross = list(bg.color = "#00007F",
					 value.const = list(fill.polygons = "#4C4C88",
					 				   fill = "#BFBFFF",
					 				   col.lines = "#BFBFFF",
					 				   col.text = "#FFE700",
					 				   col = "#00004C",
					 				   bgcol.labels_highlighted = "#00007F",
					 				   bgcol = "#00000000"),
					 value.na = list(
					 	fill = "grey60",
					 	col = "grey60",
					 	col.raster = "grey60"),
					 value.null = list(
					 	fill = "#4C4C88",
					 	col = "#4C4C88",
					 	col.polygons = "#4C4C88"),
					 values.var = list(fill = list(seq = "brewer.yl_or_rd", div = "brewer.rd_yl_gn", unord = "brewer.set3", ord = "brewer.yl_or_rd"),
					 				  col = list(seq = "brewer.yl_or_rd", div = "brewer.rd_yl_gn", unord = "brewer.set3", ord = "brewer.yl_or_rd")),
					 attr.color = "#BFBFFF",
					 basemap.alpha = .5),
	beaver = list(bg.color = "#FFFFFF",
				  value.const = list(fill.polygons = "#FFE200",
				  				   fill = "#A30000",
				  				   col.lines = "#A30000",
				  				   col = "#00004C",
				  				   bgcol.labels_highlighted = "#FFFFFF",
				  				   bgcol = "#00000000"),
				  value.na = list(
				  	fill = "grey80",
				  	col = "grey80",
				  	col.raster = "grey80"),
				  value.null = list(
				  	fill = "grey95",
				  	col = "grey95",
				  	col.polygons = "grey95"),
				  values.var = list(fill = list(seq = "brewer.yl_or_br", div = "brewer.rd_yl_gn", unord = "brewer.dark2", ord = "brewer.yl_or_br"),
				  				  col = list(seq = "brewer.yl_or_br", div = "brewer.rd_yl_gn", unord = "brewer.dark2", ord = "brewer.yl_or_br")),
				  attr.color = "black"),
	bw = list(color.saturation = 0),
	classic = list(color.sepia_intensity = .7,
				   text.fontfamily = "serif",
				   frame = TRUE,
				   frame.double_line = TRUE,
				   compass.type = "rose"),
	watercolor = list(value.const = list(fill = "#D95F02",
										 fill.dots = "red",
										 col.lines = "red",
										 col = "black",
										 bgcol.labels_highlighted = "white",
										 bgcol = "#00000000"),
					  value.na = list(
					  	fill = "grey80",
					  	col = "grey80",
					  	col.raster = "grey80"),
					  value.null = list(
					  	fill = "#FDCDAC",
					  	col = "#FDCDAC",
					  	col.polygons = "#FDCDAC"),
					  values.var = list(fill = list(seq = "brewer.greens", div = "brewer.pi_yg", unord = "brewer.pastel1", ord = "brewer.greens"),
					  				  col = list(seq = "brewer.greens", div = "brewer.pi_yg", unord = "brewer.pastel1", ord = "brewer.greens")),
					  basemap.server = "Stadia.StamenWatercolor")
)

.defaultTmapStyles = list(
	gray = styles$gray,
	grey = styles$grey,
	natural = styles$natural,
	cobalt = styles$cobalt,
	albatross = styles$albatross,
	beaver = styles$beaver,
	bw = styles$bw,
	classic = styles$classic,
	watercolor = styles$watercolor,
	v3 = styles$v3,
	gray_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$gray))], styles$gray),
	grey_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$grey))], styles$grey),
	natural_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$natural))], styles$natural),
	cobalt_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$cobalt))], styles$cobalt),
	albatross_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$albatross))], styles$albatross),
	beaver_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$beaver))], styles$beaver),
	bw_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$bw))], styles$bw),
	classic_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$classic))], styles$classic),
	watercolor_v3 = c(styles$v3[setdiff(names(styles$v3), names(styles$watercolor))], styles$watercolor)
)
