% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{renderTmap}
\alias{renderTmap}
\alias{tmapOutput}
\alias{tmapProxy}
\alias{tm_remove_layer}
\title{Wrapper functions for using \strong{tmap} in \strong{shiny}}
\usage{
renderTmap(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  execOnResize = TRUE,
  mode = NA
)

tmapOutput(outputId, width = "100\%", height = 400, mode = NA)

tmapProxy(mapId, session = shiny::getDefaultReactiveDomain(), x, mode = NA)

tm_remove_layer(zindex)
}
\arguments{
\item{expr}{A tmap object. A tmap object is created with \code{\link[=qtm]{qtm()}} or by stacking \code{\link{tmap-element}}s.}

\item{env}{The environment in which to evaluate expr}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This is useful if you want to save an expression in a variable}

\item{execOnResize}{If \code{TRUE} (default), when the plot is resized, the map is regenerated. When set to \code{FALSE} the map is rescaled: the aspect ratio is kept, but the layout will be less desirable.}

\item{mode}{tmap mode, see \code{\link[=tmap_mode]{tmap_mode()}} If not defined, the current mode is used}

\item{outputId}{Output variable to read from}

\item{width, height}{the width and height of the map}

\item{mapId}{single-element character vector indicating the output ID of the map to modify (if invoked from a Shiny module, the namespace will be added automatically)}

\item{session}{the Shiny session object to which the map belongs; usually the default value will suffice}

\item{x}{the tmap object that specifies the added and removed layers.}

\item{zindex}{the z index of the pane in which the layer is contained that is going to be removed. It is recommended to specify the \code{zindex} for this layer when creating the map (inside \code{renderTmap()}).}
}
\description{
\itemize{
\item \code{tmapOutput()} creates a UI element
\item \code{renderTmap()} renders a tmap map
\item \code{tmapProxy()} updates a tmap map in \code{view} mode
}

Adding layers is as usual via the map layer functions like \code{\link[=tm_polygons]{tm_polygons()}}.
Removing layers can be done, removing with \code{tm_remove_layer()}.
}
\details{
Two features from tmap are not (yet) supported in Shiny: small multiples (facets) and colored backgrounds (argument \code{bg.color} of \code{\link[=tm_layout]{tm_layout()}}).
Workarounds for small multiples: create multiple independent maps or specify \code{as.layers = TRUE} in \code{\link[=tm_facets]{tm_facets()}}.
}
\examples{
if (interactive() && require("shiny")) {

	data(World)
	world_vars <- setdiff(names(World), c("iso_a3", "name", "sovereignt", "geometry"))

	current.mode <- tmap_mode("plot")

	shinyApp(
		ui = fluidPage(
			tmapOutput("map", height = "600px"),
			selectInput("var", "Variable", world_vars)
		),
		server <- function(input, output, session) {
			output$map <- renderTmap({
				tm_shape(World) +
					tm_polygons(input$var, zindex = 401)
			})
		}
	)

	tmap_mode("view")

	shinyApp(
		ui = fluidPage(
			tmapOutput("map", height = "600px"),
			selectInput("var", "Variable", world_vars)
		),
		server <- function(input, output, session) {
			output$map <- renderTmap({
				tm_shape(World, id = "iso_a3") +
					tm_polygons(fill = world_vars[1], zindex = 401)
			})
			observe({
				var <- input$var
				tmapProxy("map", session, {
					tm_remove_layer(401) +
						tm_shape(World, id = "iso_a3") +
						tm_polygons(fill = var, zindex = 401)
				})
			})
		},options = list(launch.browser=TRUE)
	)

	tmap_mode(current.mode)
}
}
