% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmhmm.R
\docType{package}
\name{tmhmm}
\alias{tmhmm}
\title{tmhmm: estimate the topoplogy of membrane proteins}
\description{
Each amino acid that is part a membrane protein can be
located either in the cytosol, membrane or at the exterior.
'tmhmm' estimate this topology
}
\examples{

if (is_tmhmm_installed()) {
  fasta_filename <- system.file("extdata", "tmhmm.fasta", package = "tmhmm")
  locatome <- run_tmhmm(fasta_filename)

  # Show as text
  message(locatome, sep = "\n")

  # Show as data frame
  message(locatome_to_df(locatome))

  # Show as plot
  plot_locatome(locatome)
}
}
\author{
Richèl J.C. Bilderbeek
}
