% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralities.R
\name{centralities}
\alias{centralities}
\alias{centralities.tna}
\alias{centralities.matrix}
\alias{centralities.group_tna}
\title{Calculate Centrality Measures for a Transition Matrix}
\usage{
centralities(x, loops = FALSE, normalize = FALSE, measures, ...)

\method{centralities}{tna}(x, loops = FALSE, normalize = FALSE, measures, ...)

\method{centralities}{matrix}(x, loops = FALSE, normalize = FALSE, measures, ...)

\method{centralities}{group_tna}(x, loops = FALSE, normalize = FALSE, measures, ...)
}
\arguments{
\item{x}{A \code{tna} object, a \code{group_tna} object, or a  square \code{matrix} representing edge weights.}

\item{loops}{A \code{logical} value indicating whether to include loops in the
network when computing the centrality measures (default is \code{FALSE}).}

\item{normalize}{A \code{logical} value indicating whether the centralities
should be normalized (default is \code{FALSE}).}

\item{measures}{A \code{character} vector indicating which centrality
measures should be computed. If missing, all available measures are
returned. See 'Details' for available measures. The elements are partially
matched ignoring case.}

\item{...}{Ignored.}
}
\value{
A \code{centralities} object which is a tibble (\code{tbl_df})
containing centrality measures for each state.
}
\description{
Calculates several centrality measures. See 'Details' for
information about the measures.
}
\details{
The following measures are provided:
\itemize{
\item \code{OutStrength}: Outgoing strength centrality, calculated using
\code{\link[igraph:strength]{igraph::strength()}} with \code{mode = "out"}. It measures the total weight
of the outgoing edges from each node.
\item \code{InStrength}: Incoming strength centrality, calculated using
\code{\link[igraph:strength]{igraph::strength()}} with \code{mode = "in"}. It measures the total weight
of the incoming edges to each node.
\item \code{ClosenessIn}: Closeness centrality (incoming), calculated using
\code{\link[igraph:closeness]{igraph::closeness()}} with \code{mode = "in"}. It measures how close a node
is to all other nodes based on the incoming paths.
\item \code{ClosenessOut}: Closeness centrality (outgoing), calculated using
\code{\link[igraph:closeness]{igraph::closeness()}} with \code{mode = "out"}. It measures how close a node
is to all other nodes based on the outgoing paths.
\item \code{Closeness}: Closeness centrality (overall), calculated using
\code{\link[igraph:closeness]{igraph::closeness()}} with \code{mode = "all"}. It measures how close a node
is to all other nodes based on both incoming and outgoing paths.
\item \code{Betweenness}: Betweenness centrality defined by the number of
geodesics calculated using \code{\link[igraph:betweenness]{igraph::betweenness()}}.
\item \code{BetweennessRSP}: Betweenness centrality based on randomized shortest
paths (Kivimäki et al. 2016). It measures the extent to which a
node lies on the shortest paths between other nodes.
\item \code{Diffusion}: Diffusion centrality of Banerjee et.al. (2014).
It measures the influence of a node in spreading information through
the network.
\item \code{Clustering}: Signed clustering coefficient of Zhang and Horvath (2005)
based on the symmetric adjacency matrix (sum of the adjacency matrix
and its transpose). It measures the degree to which nodes tend to
cluster together.
}
}
\examples{
model <- tna(engagement)

# Centrality measures including loops in the network
centralities(model)

# Centrality measures excluding loops in the network
centralities(model, loops = FALSE)

# Centrality measures normalized
centralities(model, normalize = TRUE)

}
\seealso{
Core functions
\code{\link{build_model}()},
\code{\link{plot.tna}()},
\code{\link{plot.tna_centralities}()},
\code{\link{plot_compare}()}

Cluster-related functions
\code{\link{bootstrap}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_centralities}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.group_tna_bootstrap}()}
}
\concept{clusters}
\concept{core}
