% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_cliques}
\alias{plot.tna_cliques}
\title{Plot Cliques of a TNA Network}
\usage{
\method{plot}{tna_cliques}(
  x,
  n = 6,
  first = 1,
  show_loops = FALSE,
  minimum = 0.00001,
  mar = rep(5, 4),
  ask = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{tna_cliques} object.}

\item{n}{An \code{integer} defining the maximum number of cliques to show.
The defaults is \code{6}.}

\item{first}{An \code{integer} giving the index of the first clique to show.
The default index is \code{1}.}

\item{show_loops}{A \code{logical} value indicating whether to include loops
in the plots or not.}

\item{minimum}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{mar}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{ask}{A \code{logical} value. When \code{TRUE}, show plots one by one and asks
to plot the next plot in interactive mode.}

\item{...}{Ignored.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Plot Cliques of a TNA Network
}
\examples{
model <- tna(engagement)
cliq <- cliques(model, size = 2)
plot(cliq, n = 1)

}
