% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tntp_cred.R
\name{tntp_cred}
\alias{tntp_cred}
\alias{tntp_cred_set}
\alias{tntp_cred_list}
\title{TNTP Credential Get/Set Command}
\usage{
tntp_cred(service, username = NULL, keyring = NULL, prompt = NULL)

tntp_cred_set(
  service = NULL,
  username = NULL,
  keyring = NULL,
  prompt = NULL,
  overwrite = NULL
)

tntp_cred_list(service = NULL, keyring = NULL)
}
\arguments{
\item{service}{The identifier for the credential you are pulling or setting}

\item{username}{OPTIONAL. Can be used to specify different usernames for the same service}

\item{keyring}{OPTIONAL. Can be used to specify a specific keyring}

\item{prompt}{OPTIONAL. What text should be displayed above the input box for the key while setting?}

\item{overwrite}{OPTIONAL. By default, \code{tntp_cred_set()} will prompt if it finds a credential already saved. Set this to \code{TRUE} to overwrite without prompting or \code{FALSE} to throw an error if a current credential is found.}
}
\value{
\itemize{
\item \code{tntp_cred()} returns a stored (or newly created) credential
\item \code{tntp_cred_set()} returns nothing
\item \code{tntp_cred_list()} returns a 2-column data frame of services and usernames
}
}
\description{
A wrapper around the \code{keyring} package for secure credential management.

\code{tntp_cred()} will attempt to get a credential, and if no credential is found
it will prompt you to add it (and then return it).

\code{tntp_cred_set()} will set a credential. By default it will prompt before
overwriting any current credentials.

\code{tntp_cred_list()} will list all current credentials by sorted by service
and username.
}
\examples{
\dontshow{if (interactive() && rlang::is_installed("qualtRics")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Using tntp_cred() with qualtRics
library(qualtRics)

# If no credential is set, this command will prompt for it first
qualtrics_token <- tntp_cred("QUALTRICS_TOKEN")
qualtrics_api_credentials(api_key = qualtrics_token,
                          base_url = 'tntp.co1.qualtrics.com')

# To overwrite your Qualtrics credential
tntp_cred("QUALTRICS_TOKEN", .set = TRUE)
\dontshow{\}) # examplesIf}
}
