% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament.R
\name{bart_tourney_odds}
\alias{bart_tourney_odds}
\title{Get NCAA Tournament Odds}
\usage{
bart_tourney_odds(year = current_season(), odds = "current")
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{odds}{Filters results by odds, defaults to current (see details).}
}
\value{
Returns a tibble with 10 to 11 columns (depending on year input):
#' \describe{
  \item{\code{seed}}{double.}
  \item{\code{region}}{character. Only avaliable for year >= 2022}
  \item{\code{team}}{character.}
  \item{\code{conf}}{character.}
  \item{\code{r64}}{double.}
  \item{\code{r32}}{double.}
  \item{\code{s16}}{double.}
  \item{\code{e8}}{double.}
  \item{\code{f4}}{double.}
  \item{\code{f2}}{double.}
  \item{\code{champ}}{double.}
}
}
\description{
Returns a tibble with round-to-round tournament probabilities. Data runs back
to the 2018 tournament; region is only avaliable for the 2022 tournament.
}
\details{
\code{odds} splits the data by four variables: \describe{ \item{current}{Returns
to-date odds.} \item{pre}{Returns pre-tournament odds} \item{recent}{Returns
adjusted odds over the last ten games} \item{t100}{Returns odds against top
100 opponents.}}
}
\examples{
bart_tourney_odds(year=2022, odds='pre')

}
