% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeGraph.R
\name{toaGraph}
\alias{toaGraph}
\title{Define an object corresponding to a graph in Aster database.}
\usage{
toaGraph(vertices, edges, directed = FALSE, key = "id", source = "source",
  target = "target", vertexAttrnames = NULL, edgeAttrnames = NULL,
  vertexWhere = NULL, edgeWhere = NULL)
}
\arguments{
\item{vertices}{A table, view, or query of a collection of vertices in the graph.}

\item{edges}{A table, view, or query of a collection of edges of the graph. 
The collection must contain at least two lists of columns, one list that represents 
the source vertex key and another list that represents the target vertex key.}

\item{directed}{logical: should edges be interpreted as directed?}

\item{key}{name of the column with vertex unique id (in the table \code{vertices}).}

\item{source}{name of the column with the from vertex (in the table \code{edges}).}

\item{target}{name of the column with the to vertex (in the tbale \code{edges}).}

\item{vertexAttrnames}{optionally, a list of columns containing vertex 
attribute names.}

\item{edgeAttrnames}{optionally, a list of columns containing edge 
attribute names.}

\item{vertexWhere}{optionally, a \code{SQL WHERE} clause to subset vertex table (use SQL 
as if in \code{WHERE} clause but omit the keyword \code{WHERE}).}

\item{edgeWhere}{optionally, a \code{SQL WHERE} clause to subset edge table (use SQL 
as if in \code{WHERE} clause but omit the keyword \code{WHERE}).}
}
\description{
In Aster Database, to process graphs using SQL-GR, it is recommended to represent
a graph using two tables:
\enumerate{
  \item Vertices table
  \item edges table
}
Vertices table must contain a unique key so that each row represents a vertex.
Edges table must contain a pair of source and target keys (from vertices table)
so that each row represents an edge.
Both vertices and edges tables may contain additional columns representing 
optional attributes. For example if edges table has column 'weight' it can
correspond a graph with edge weights.
}
\examples{
# undirected graph
policeGraphUn = toaGraph("dallaspolice_officer_vertices", "dallaspolice_officer_edges_un", 
     directed = FALSE, key = "officer", source = "officer1", target = "officer2", 
     vertexAttrnames = c("offense_count"), edgeAttrnames = c("weight"))
                         
# directed graph with the vertex filter
policeGraphDi = toaGraph("dallaspolice_officer_vertices", "dallaspolice_officer_edges_di", 
     directed = TRUE, key = "officer", source = "officer1", target = "officer2", 
     vertexAttrnames = c("offense_count"), edgeAttrnames = c("weight"),
     vertexWhere = "officer ~ '[A-Z].*'")
     
}

