% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-options.R
\name{cal_timezone}
\alias{cal_timezone}
\title{Calendar Timezone}
\usage{
cal_timezone(
  cal,
  timezoneName = NULL,
  displayLabel = NULL,
  tooltip = NULL,
  extra_zones = NULL,
  offsetCalculator = NULL
)
}
\arguments{
\item{cal}{A \code{\link[=calendar]{calendar()}} object.}

\item{timezoneName}{timezone name (time zone names of the IANA time zone database, such as 'Asia/Seoul', 'America/New_York').
Basically, it will calculate the offset using 'Intl.DateTimeFormat' with the value of the this property entered.}

\item{displayLabel}{The display label of your timezone at weekly/daily view(e.g. 'GMT+09:00')}

\item{tooltip}{The tooltip(e.g. 'Seoul')}

\item{extra_zones}{A \code{list} with additional timezones to be shown in left timegrid of weekly/daily view.}

\item{offsetCalculator}{Javascript function. If you define the 'offsetCalculator' property, the offset calculation is done with this function.}
}
\value{
A \code{calendar} htmlwidget.
}
\description{
Set a custom time zone. You can add secondary timezone in the weekly/daily view.
}
\note{
Online JavaScript documentation: \url{https://github.com/nhn/tui.calendar/blob/main/docs/en/apis/options.md#timezone}
}
\examples{
library(toastui)
calendar(view = "week", defaultDate = "2021-06-18") \%>\%
  cal_schedules(
    title = "My schedule",
    start = "2021-06-18T10:00:00",
    end = "2021-06-18T17:00:00",
    category = "time"
  ) \%>\%
  # Set primary timezone and add secondary timezone
  cal_timezone(
    timezoneName = "Europe/Paris",
    displayLabel = "GMT+02:00",
    tooltip = "Paris",
    extra_zones = list(
      list(
        timezoneName = "Asia/Seoul",
        displayLabel = "GMT+09:00",
        tooltip = "Seoul"
      )
    )
  )
}
