% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-summary.R
\name{grid_summary}
\alias{grid_summary}
\title{Add summary area to grid}
\usage{
grid_summary(
  grid,
  columns,
  stat = c("sum", "min", "max", "avg"),
  digits = 0,
  label = NULL,
  sep = "<br>",
  position = c("bottom", "top"),
  height = 40,
  js_function = NULL
)
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{columns}{Name of column (variable name) for which to add a summary.}

\item{stat}{Statistic to display: \code{"sum"}, \code{"min"}, \code{"max"} or \code{"avg"}. Can be several values.}

\item{digits}{Number of digits to display.}

\item{label}{Label to display next to statistic.}

\item{sep}{Separator between several statistics.}

\item{position}{The position of the summary area: \code{"bottom"} or \code{"top"}.}

\item{height}{The height of the summary area.}

\item{js_function}{JavaScript function to compute the statistic you want.
Function should have one argument, it will be the values of the column.
If used, \code{stat}, \code{digits}, \code{label} and \code{sep} will be ignored.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Add summary area to grid
}
\examples{
library(toastui)

# Add a line with sum of column
datagrid(ps3_games[, c(1, 5, 6, 7, 8)], colwidths = "guess") \%>\% 
  grid_summary(
    column = "NA_Sales",
    stat = "sum"
  )

# Do that for several columns
datagrid(ps3_games[, c(1, 5, 6, 7, 8)], colwidths = "guess") \%>\% 
  grid_summary(
    column = c("NA_Sales", "EU_Sales", "JP_Sales", "Other_Sales"),
    stat = "sum",
    label = "Total: "
  )
}
