% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{smbltest}
\alias{smbltest}
\title{Smith and Blundell Test}
\usage{
smbltest(formula, data)
}
\arguments{
\item{formula}{a two part formula, with the instruments in the
second part}

\item{data}{a data.frame}
}
\value{
a list with class \code{'htest'} containing the following components:
\itemize{
\item data.mane: a character string describing the fitted model
\item statistic: the value of the test statistic
\item parameter: degrees of freedom
\item p.value: the p.value of the test
\item method: a character indicating what type of test is performed
\item alternative: a character indicating the alternative hypothesis
}
}
\description{
Test for Exogeneity in Tobit models
}
\examples{
library("Formula")
inst <- ~ sic3 + k_serv + inv + engsci + whitecol + skill + semskill + cropland + 
    pasture + forest + coal + petro + minerals + scrconc + bcrconc +
    scrcomp + bcrcomp + meps + 
    kstock + puni + geog2 + tenure + klratio + bunion
tradeprotection <- dplyr::mutate(tradeprotection,
                                 y  = ntb / (1 + ntb),
                                 x1 = exports / imports / elast,
                                 x2 = cap * x1)
smbltest(Formula::as.Formula(y ~ x1 + x2 + labvar, inst), tradeprotection)
}
\references{
\insertRef{SMIT:BLUN:86}{tobit1}
}
\author{
Yves Croissant
}
\keyword{htest}
