% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{chefdetails}
\alias{chefdetails}
\title{chefdetails}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{name}}{Chef name (full name)}
  \item{\code{chef}}{Shorter version of the chef's name}
  \item{\code{hometown}}{Chef's hometown, if known}
  \item{\code{city}}{City in which the Chef lived at the time of show}
  \item{\code{state}}{State in which the Chef lived at the time of the show}
  \item{\code{age}}{Age of Chef at the time of the show}
  \item{\code{season}}{Name of season}
  \item{\code{seasonNumber}}{Season number}
  \item{\code{series}}{Top Chef US (listed as US); Top Chef US Masters
                       (listed as US Masters); Top Chef Canada (listed
                       as Canada)}
  \item{\code{placement}}{Final result of the Chef.}
  \item{\code{personOfColor}}{Flag for whether the Chef is a person of color.
                   Will be blank if they are not}
  \item{\code{occupation}}{Occupation of Chef at time of show, if known}
  \item{\code{gender}}{Gender of Chef}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Top_Chef}
}
\usage{
data(chefdetails)
}
\description{
A dataset containing information on each Chef for each season. As of now,
it has data for all Top Chef US seasons, Top Chef Masters (US), and one
season of Top Chef Canada.
}
\examples{
library(dplyr)
library(tidyr)
chefdetails \%>\%
  filter(season == "World All Stars")
}
\keyword{datasets}
