% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{rewards}
\alias{rewards}
\title{rewards}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{season}}{Name of season}
  \item{\code{seasonNumber}}{Season number}
  \item{\code{series}}{Top Chef US (listed as US); Top Chef US Masters
  (listed as US Masters); Top Chef Canada (listed as Canada)}
  \item{\code{episode}}{Episode number}
  \item{\code{challengeType}}{Challenge type: qualifying challenge,
  elimination, quickfire, sudden death quickfire, quickfire elimination,
  battle of the sous chefs}
  \item{\code{outcomeType}}{Is the challenge run as a team or as an
  individual?}
  \item{\code{rewardType}}{Variable describing whether the reward is
  money or a prize}
  \item{\code{reward}}{Description of the full reward}
  \item{\code{chef}}{Name of chef}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Top_Chef}
}
\usage{
data(rewards)
}
\description{
A dataset containing information about rewards and prizes won by challenge
}
\examples{
library(dplyr)
library(tidyr)
rewards \%>\%
  filter(rewardType == "Money") \%>\%
  mutate(reward=as.numeric(reward)) \%>\%
  group_by(season) \%>\%
  summarise(total=sum(reward))
}
\keyword{datasets}
