% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{calculate_annual_distances}
\alias{calculate_annual_distances}
\title{Calculate Annual Distance Metrics}
\usage{
calculate_annual_distances(df_coords, ndim, na.rm = TRUE)
}
\arguments{
\item{df_coords}{Data frame containing:
- V1...Vn coordinate columns
- year: Numeric years
- name: Point identifiers (will use rownames if missing)}

\item{ndim}{Number of coordinate dimensions}

\item{na.rm}{Logical indicating whether to remove NA values}
}
\value{
A list containing year-over-year antigenic distance metrics:
\item{dist_data}{A \code{data.frame} where each row represents a point and its \code{distance}
to the mean coordinate of the previous year.}
\item{summary}{A list containing the \code{overall_mean} and \code{overall_sd} (standard deviation)
of the annual distances across all years.}
}
\description{
Calculates year-over-year antigenic distances and statistics. Compares each point
to the mean coordinates of the previous year.
}
\examples{
# Create sample coordinate data
coords <- data.frame(V1 = rnorm(10), V2 = rnorm(10), year = rep(2000:2004, 2))
annual_stats <- calculate_annual_distances(coords, ndim=2)
print(annual_stats$summary$overall_mean)

}
