% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{denv_data}
\alias{denv_data}
\title{Dengue Virus (DENV) Titer Data}
\format{
A data frame with the following columns:
\describe{
\item{virus_strain}{Character, the name of the virus strain.}
\item{serum_strain}{Character, the name of the serum strain.}
\item{titer}{Character, the neutralization titer value. May include values like '<10' or '>1280'.}
\item{virusYear}{Numeric, the year the virus was isolated.}
\item{serumYear}{Numeric, the year the serum was collected.}
\item{cluster}{Factor, the cluster or serotype assignment for the strains.}
\item{color}{Character, a color associated with the cluster for plotting.}
}
}
\source{
Katzelnick, L.C., et al. (2019). An antigenically diverse, representative panel of dengue viruses for neutralizing antibody discovery and vaccine evaluation. \emph{eLife}. \doi{10.7554/eLife.42496}
}
\usage{
denv_data
}
\description{
A dataset containing neutralization titer data for Dengue virus. This data can be used to
create antigenic maps and explore the antigenic relationships between different DENV strains.
}
\keyword{datasets}
