% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_logical_and}
\alias{torch_logical_and}
\title{Logical_and}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{other}{(Tensor) the tensor to compute AND with}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Logical_and
}
\section{logical_and(input, other, out=None) -> Tensor }{


Computes the element-wise logical AND of the given input tensors. Zeros are treated as \code{False} and nonzeros are
treated as \code{True}.
}

\examples{
if (torch_is_installed()) {

torch_logical_and(torch_tensor(c(TRUE, FALSE, TRUE)), torch_tensor(c(TRUE, FALSE, FALSE)))
a = torch_tensor(c(0, 1, 10, 0), dtype=torch_int8())
b = torch_tensor(c(4, 0, 1, 0), dtype=torch_int8())
torch_logical_and(a, b)
\dontrun{
torch_logical_and(a, b, out=torch_empty(4, dtype=torch_bool()))
}
}
}
