% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_unique_consecutive}
\alias{torch_unique_consecutive}
\title{Unique_consecutive}
\arguments{
\item{input}{(Tensor) the input tensor}

\item{return_inverse}{(bool) Whether to also return the indices for where        elements in the original input ended up in the returned unique list.}

\item{return_counts}{(bool) Whether to also return the counts for each unique        element.}

\item{dim}{(int) the dimension to apply unique. If \code{None}, the unique of the        flattened input is returned. default: \code{None}}
}
\description{
Unique_consecutive
}
\section{TEST }{


Eliminates all but the first element from every consecutive group of equivalent elements.\preformatted{.. note:: This function is different from [`torch_unique`] in the sense that this function
    only eliminates consecutive duplicate values. This semantics is similar to `std::unique`
    in C++.
}
}

\examples{
if (torch_is_installed()) {
x = torch_tensor(c(1, 1, 2, 2, 3, 1, 1, 2))
output = torch_unique_consecutive(x)
output
torch_unique_consecutive(x, return_inverse=TRUE)
torch_unique_consecutive(x, return_counts=TRUE)
}
}
