% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_argmax}
\alias{torch_argmax}
\title{Argmax}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to reduce. If \code{None}, the argmax of the flattened input is returned.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not. Ignored if \code{dim=None}.}
}
\description{
Argmax
}
\section{argmax(input) -> LongTensor }{


Returns the indices of the maximum value of all elements in the \code{input} tensor.

This is the second value returned by \code{torch_max}. See its
documentation for the exact semantics of this method.
}

\section{argmax(input, dim, keepdim=False) -> LongTensor }{


Returns the indices of the maximum values of a tensor across a dimension.

This is the second value returned by \code{torch_max}. See its
documentation for the exact semantics of this method.
}

\examples{
if (torch_is_installed()) {

\dontrun{
a = torch_randn(c(4, 4))
a
torch_argmax(a)
}


a = torch_randn(c(4, 4))
a
torch_argmax(a, dim=1)
}
}
