% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_median}
\alias{torch_median}
\title{Median}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to reduce.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}

\item{out}{(tuple, optional) the result tuple of two output tensors (max, max_indices)}
}
\description{
Median
}
\section{median(input) -> Tensor }{


Returns the median value of all elements in the \code{input} tensor.
}

\section{median(input, dim=-1, keepdim=False, out=None) -> (Tensor, LongTensor) }{


Returns a namedtuple \verb{(values, indices)} where \code{values} is the median
value of each row of the \code{input} tensor in the given dimension
\code{dim}. And \code{indices} is the index location of each median value found.

By default, \code{dim} is the last dimension of the \code{input} tensor.

If \code{keepdim} is \code{True}, the output tensors are of the same size
as \code{input} except in the dimension \code{dim} where they are of size 1.
Otherwise, \code{dim} is squeezed (see \code{\link{torch_squeeze}}), resulting in
the outputs tensor having 1 fewer dimension than \code{input}.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(1, 3))
a
torch_median(a)


a = torch_randn(c(4, 5))
a
torch_median(a, 1)
}
}
