% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_softmax2d}
\alias{nn_softmax2d}
\title{Softmax2d module}
\usage{
nn_softmax2d()
}
\value{
a Tensor of the same dimension and shape as the input with
values in the range \verb{[0, 1]}
}
\description{
Applies SoftMax over features to each spatial location.
When given an image of \verb{Channels x Height x Width}, it will
apply \code{Softmax} to each location \eqn{(Channels, h_i, w_j)}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, H, W)}
\item Output: \eqn{(N, C, H, W)} (same shape as input)
}
}

\examples{
if (torch_is_installed()) {
m <- nn_softmax2d()
input <- torch_randn(2, 3, 12, 13)
output <- m(input)

}
}
