% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_norm}
\alias{linalg_norm}
\title{Computes a vector or matrix norm.}
\usage{
linalg_norm(A, ord = NULL, dim = NULL, keepdim = FALSE, dtype = NULL)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, n)} or \verb{(*, m, n)} where \code{*} is zero or more batch dimensions}

\item{ord}{(int, float, inf, -inf, 'fro', 'nuc', optional): order of norm. Default: \code{NULL}}

\item{dim}{(int, Tuple\link{int}, optional): dimensions over which to compute
the vector or matrix norm. See above for the behavior when \code{dim=NULL}.
Default: \code{NULL}}

\item{keepdim}{(bool, optional): If set to \code{TRUE}, the reduced dimensions are retained
in the result as dimensions with size one. Default: \code{FALSE}}

\item{dtype}{dtype (\code{torch_dtype}, optional): If specified, the input tensor is cast to
\code{dtype} before performing the operation, and the returned tensor's type
will be \code{dtype}. Default: \code{NULL}}
}
\description{
If \code{A} is complex valued, it computes the norm of \code{A$abs()}
Supports input of float, double, cfloat and cdouble dtypes.
Whether this function computes a vector or matrix norm is determined as follows:
}
\details{
\itemize{
\item If \code{dim} is an int, the vector norm will be computed.
\item If \code{dim} is a 2-tuple, the matrix norm will be computed.
\item If \code{dim=NULL} and \code{ord=NULL}, A will be flattened to 1D and the 2-norm of the resulting vector will be computed.
\item If \code{dim=NULL} and \code{ord!=NULL}, A must be 1D or 2D.
}

\code{ord} defines the norm that is computed. The following norms are
supported:\tabular{lll}{
   \code{ord} \tab norm for matrices \tab norm for vectors \cr
   \code{NULL} (default) \tab Frobenius norm \tab \code{2}-norm (see below) \cr
   \code{"fro"} \tab Frobenius norm \tab – not supported – \cr
   \code{"nuc"} \tab nuclear norm \tab – not supported – \cr
   \code{Inf} \tab \code{max(sum(abs(x), dim=2))} \tab \code{max(abs(x))} \cr
   \code{-Inf} \tab \code{min(sum(abs(x), dim=2))} \tab \code{min(abs(x))} \cr
   \code{0} \tab – not supported – \tab \code{sum(x != 0)} \cr
   \code{1} \tab \code{max(sum(abs(x), dim=1))} \tab as below \cr
   \code{-1} \tab \code{min(sum(abs(x), dim=1))} \tab as below \cr
   \code{2} \tab largest singular value \tab as below \cr
   \code{-2} \tab smallest singular value \tab as below \cr
   other \code{int} or \code{float} \tab – not supported – \tab \code{sum(abs(x)^{ord})^{(1 / ord)}} \cr
}
}
\examples{
if (torch_is_installed()) {
a <- torch_arange(0, 8, dtype = torch_float()) - 4
a
b <- a$reshape(c(3, 3))
b

linalg_norm(a)
linalg_norm(b)
}
}
\seealso{
Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
